/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.OpenTelemetryBuilder;
import io.opentelemetry.api.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.spi.metrics.MeterProviderFactory;
import io.opentelemetry.spi.trace.TracerProviderFactory;
import java.util.Objects;

public class DefaultOpenTelemetryBuilder
implements OpenTelemetryBuilder<DefaultOpenTelemetryBuilder> {
    protected ContextPropagators propagators = ContextPropagators.noop();
    protected TracerProvider tracerProvider;
    protected MeterProvider meterProvider;

    @Override
    public DefaultOpenTelemetryBuilder setTracerProvider(TracerProvider tracerProvider) {
        Objects.requireNonNull(tracerProvider, "tracerProvider");
        this.tracerProvider = tracerProvider;
        return this;
    }

    @Override
    @Deprecated
    public DefaultOpenTelemetryBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    @Override
    public DefaultOpenTelemetryBuilder setPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        this.propagators = propagators;
        return this;
    }

    @Override
    public OpenTelemetry build() {
        TracerProvider tracerProvider;
        MeterProvider meterProvider = this.meterProvider;
        if (meterProvider == null) {
            MeterProviderFactory meterProviderFactory = Utils.loadSpi(MeterProviderFactory.class);
            meterProvider = meterProviderFactory != null ? meterProviderFactory.create() : MeterProvider.getDefault();
        }
        if ((tracerProvider = this.tracerProvider) == null) {
            TracerProviderFactory tracerProviderFactory = Utils.loadSpi(TracerProviderFactory.class);
            tracerProvider = tracerProviderFactory != null ? tracerProviderFactory.create() : TracerProvider.getDefault();
        }
        return new DefaultOpenTelemetry(tracerProvider, meterProvider, this.propagators);
    }
}

