/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AttributesBuilder {
    private final List<Object> data;

    AttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    AttributesBuilder(List<Object> data) {
        this.data = data;
    }

    public Attributes build() {
        return Attributes.sortAndFilterToAttributes(this.data.toArray());
    }

    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put(key, Long.valueOf(value));
    }

    public <T> AttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || key.getKey().length() == 0 || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    public AttributesBuilder put(String key, String value) {
        return this.put(AttributeKey.stringKey(key), value);
    }

    public AttributesBuilder put(String key, long value) {
        return this.put(AttributeKey.longKey(key), Long.valueOf(value));
    }

    public AttributesBuilder put(String key, double value) {
        return this.put(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    public AttributesBuilder put(String key, boolean value) {
        return this.put(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    public AttributesBuilder put(String key, String ... value) {
        return this.put(AttributeKey.stringArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    public AttributesBuilder put(String key, Long ... value) {
        return this.put(AttributeKey.longArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    public AttributesBuilder put(String key, Double ... value) {
        return this.put(AttributeKey.doubleArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    public AttributesBuilder put(String key, Boolean ... value) {
        return this.put(AttributeKey.booleanArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    public AttributesBuilder putAll(Attributes attributes) {
        attributes.forEach(this::put);
        return this;
    }
}

