/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TracingContextUtils {
    private static final ContextKey<Span> CONTEXT_SPAN_KEY = ContextKey.named((String)"opentelemetry-trace-span-key");

    public static Context withSpan(Span span, Context context) {
        return context.withValues(CONTEXT_SPAN_KEY, (Object)span);
    }

    public static Span getCurrentSpan() {
        return TracingContextUtils.getSpan(Context.current());
    }

    public static Span getSpan(Context context) {
        Span span = (Span)context.getValue(CONTEXT_SPAN_KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span getSpanWithoutDefault(Context context) {
        return (Span)context.getValue(CONTEXT_SPAN_KEY);
    }

    @MustBeClosed
    public static Scope currentContextWith(Span span) {
        return TracingContextUtils.withSpan(span, Context.current()).makeCurrent();
    }

    private TracingContextUtils() {
    }
}

