/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.baggage;

import io.opentelemetry.baggage.Baggage;
import io.opentelemetry.baggage.EmptyBaggage;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BaggageUtils {
    private static final ContextKey<Baggage> CORR_CONTEXT_KEY = ContextKey.named((String)"opentelemetry-corr-context-key");

    public static Context withBaggage(Baggage baggage, Context context) {
        return context.withValues(CORR_CONTEXT_KEY, (Object)baggage);
    }

    public static Baggage getCurrentBaggage() {
        return BaggageUtils.getBaggage(Context.current());
    }

    public static Baggage getBaggage(Context context) {
        Baggage baggage = (Baggage)context.getValue(CORR_CONTEXT_KEY);
        return baggage == null ? EmptyBaggage.getInstance() : baggage;
    }

    @Nullable
    public static Baggage getBaggageWithoutDefault(Context context) {
        return (Baggage)context.getValue(CORR_CONTEXT_KEY);
    }

    public static Scope currentContextWith(Baggage baggage) {
        Context context = BaggageUtils.withBaggage(baggage, Context.current());
        return context.makeCurrent();
    }

    private BaggageUtils() {
    }
}

