/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.spi.metrics.MeterProviderFactory;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class GlobalMetricsProvider {
    private static final Object mutex = new Object();
    private static final AtomicReference<MeterProvider> globalMeterProvider = new AtomicReference();

    private GlobalMetricsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MeterProvider get() {
        MeterProvider meterProvider = globalMeterProvider.get();
        if (meterProvider == null) {
            Object object = mutex;
            synchronized (object) {
                if (globalMeterProvider.get() == null) {
                    MeterProviderFactory meterProviderFactory = GlobalMetricsProvider.loadSpi();
                    meterProvider = meterProviderFactory != null ? meterProviderFactory.create() : MeterProvider.getDefault();
                    globalMeterProvider.compareAndSet(null, meterProvider);
                }
            }
        }
        return meterProvider;
    }

    public static void set(MeterProvider meterProvider) {
        globalMeterProvider.set(meterProvider);
    }

    public static Meter getMeter(String instrumentationName) {
        return GlobalMetricsProvider.get().get(instrumentationName);
    }

    public static Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return GlobalMetricsProvider.get().get(instrumentationName, instrumentationVersion);
    }

    @Nullable
    private static MeterProviderFactory loadSpi() {
        String specifiedProvider = System.getProperty(MeterProviderFactory.class.getName());
        ServiceLoader<MeterProviderFactory> providers = ServiceLoader.load(MeterProviderFactory.class);
        for (MeterProviderFactory provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }
}

