/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeTest {
    private final DocumentTraversal documentTraversal;
    private final Node rootNode;

    public NodeTest(String xmlString) throws SAXException, IOException {
        this(new StringReader(xmlString));
    }

    public NodeTest(Reader reader) throws SAXException, IOException {
        this(XMLUnit.buildDocument(XMLUnit.newControlParser(), reader));
    }

    public NodeTest(InputSource src) throws SAXException, IOException {
        this(XMLUnit.buildDocument(XMLUnit.newControlParser(), src));
    }

    public NodeTest(Document document) {
        this(NodeTest.getDocumentTraversal(document), document.getDocumentElement());
    }

    private static DocumentTraversal getDocumentTraversal(Document document) {
        try {
            return (DocumentTraversal)((Object)document);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("DOM Traversal not supported by " + document.getImplementation().getClass().getName() + ". To use this class you will need to switch to a DOM implementation that supports Traversal.");
        }
    }

    public NodeTest(DocumentTraversal documentTraversal, Node rootNode) {
        this.documentTraversal = documentTraversal;
        this.rootNode = rootNode;
    }

    public void performTest(NodeTester tester, short singleNodeType) throws NodeTestException {
        this.performTest(tester, new short[]{singleNodeType});
    }

    public void performTest(NodeTester tester, short[] nodeTypes) throws NodeTestException {
        NodeIterator iter2 = this.documentTraversal.createNodeIterator(this.rootNode, -1, new NodeTypeNodeFilter(nodeTypes), true);
        Node nextNode = iter2.nextNode();
        while (nextNode != null) {
            tester.testNode(nextNode, this);
            nextNode = iter2.nextNode();
        }
        tester.noMoreNodes(this);
    }

    private static class NodeTypeNodeFilter
    implements NodeFilter {
        private final short[] nodeTypes;

        public NodeTypeNodeFilter(short[] nodeTypes) {
            this.nodeTypes = nodeTypes;
        }

        @Override
        public short acceptNode(Node aNode) {
            if (this.acceptNodeType(aNode.getNodeType())) {
                return 1;
            }
            return 2;
        }

        private boolean acceptNodeType(short shortVal) {
            for (int i = 0; i < this.nodeTypes.length; ++i) {
                if (this.nodeTypes[i] != shortVal) continue;
                return true;
            }
            return false;
        }
    }
}

