/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jsonpath.spi.mapper;

import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jsonpath.Configuration;
import io.opentelemetry.testing.internal.jsonpath.TypeRef;
import io.opentelemetry.testing.internal.jsonpath.spi.mapper.MappingException;
import io.opentelemetry.testing.internal.jsonpath.spi.mapper.MappingProvider;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return this.objectMapper.convertValue(source, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
        try {
            return this.objectMapper.convertValue(source, type);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

