/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jsonpath.internal.path;

import io.opentelemetry.testing.internal.jsonpath.Predicate;
import io.opentelemetry.testing.internal.jsonpath.internal.function.Parameter;
import io.opentelemetry.testing.internal.jsonpath.internal.path.ArrayIndexOperation;
import io.opentelemetry.testing.internal.jsonpath.internal.path.ArrayIndexToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.ArraySliceOperation;
import io.opentelemetry.testing.internal.jsonpath.internal.path.ArraySliceToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.FunctionPathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.PathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.PredicatePathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.PropertyPathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.RootPathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.ScanPathToken;
import io.opentelemetry.testing.internal.jsonpath.internal.path.WildcardPathToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PathTokenFactory {
    public static RootPathToken createRootPathToken(char token) {
        return new RootPathToken(token);
    }

    public static PathToken createSinglePropertyPathToken(String property, char stringDelimiter) {
        return new PropertyPathToken(Collections.singletonList(property), stringDelimiter);
    }

    public static PathToken createPropertyPathToken(List<String> properties, char stringDelimiter) {
        return new PropertyPathToken(properties, stringDelimiter);
    }

    public static PathToken createSliceArrayPathToken(ArraySliceOperation arraySliceOperation) {
        return new ArraySliceToken(arraySliceOperation);
    }

    public static PathToken createIndexArrayPathToken(ArrayIndexOperation arrayIndexOperation) {
        return new ArrayIndexToken(arrayIndexOperation);
    }

    public static PathToken createWildCardPathToken() {
        return new WildcardPathToken();
    }

    public static PathToken crateScanToken() {
        return new ScanPathToken();
    }

    public static PathToken createPredicatePathToken(Collection<Predicate> predicates) {
        return new PredicatePathToken(predicates);
    }

    public static PathToken createPredicatePathToken(Predicate predicate) {
        return new PredicatePathToken(predicate);
    }

    public static PathToken createFunctionPathToken(String function, List<Parameter> parameters) {
        return new FunctionPathToken(function, parameters);
    }
}

