/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jsonpath.internal.function;

import io.opentelemetry.testing.internal.jsonpath.InvalidPathException;
import io.opentelemetry.testing.internal.jsonpath.internal.function.PathFunction;
import io.opentelemetry.testing.internal.jsonpath.internal.function.json.Append;
import io.opentelemetry.testing.internal.jsonpath.internal.function.json.KeySetFunction;
import io.opentelemetry.testing.internal.jsonpath.internal.function.numeric.Average;
import io.opentelemetry.testing.internal.jsonpath.internal.function.numeric.Max;
import io.opentelemetry.testing.internal.jsonpath.internal.function.numeric.Min;
import io.opentelemetry.testing.internal.jsonpath.internal.function.numeric.StandardDeviation;
import io.opentelemetry.testing.internal.jsonpath.internal.function.numeric.Sum;
import io.opentelemetry.testing.internal.jsonpath.internal.function.text.Concatenate;
import io.opentelemetry.testing.internal.jsonpath.internal.function.text.Length;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PathFunctionFactory {
    public static final Map<String, Class> FUNCTIONS;

    public static PathFunction newFunction(String name) throws InvalidPathException {
        Class functionClazz = FUNCTIONS.get(name);
        if (functionClazz == null) {
            throw new InvalidPathException("Function with name: " + name + " does not exist.");
        }
        try {
            return (PathFunction)functionClazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidPathException("Function of name: " + name + " cannot be created", e);
        }
    }

    static {
        HashMap<String, Class<KeySetFunction>> map = new HashMap<String, Class<KeySetFunction>>();
        map.put("avg", Average.class);
        map.put("stddev", StandardDeviation.class);
        map.put("sum", Sum.class);
        map.put("min", Min.class);
        map.put("max", Max.class);
        map.put("concat", Concatenate.class);
        map.put("length", Length.class);
        map.put("size", Length.class);
        map.put("append", Append.class);
        map.put("keys", KeySetFunction.class);
        FUNCTIONS = Collections.unmodifiableMap(map);
    }
}

