/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.servlets;

import io.opentelemetry.testing.internal.jetty.http.HttpHeader;
import io.opentelemetry.testing.internal.jetty.http.HttpURI;
import io.opentelemetry.testing.internal.jetty.server.PushBuilder;
import io.opentelemetry.testing.internal.jetty.server.Request;
import io.opentelemetry.testing.internal.jetty.server.Response;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import io.opentelemetry.testing.internal.servlet.Filter;
import io.opentelemetry.testing.internal.servlet.FilterChain;
import io.opentelemetry.testing.internal.servlet.FilterConfig;
import io.opentelemetry.testing.internal.servlet.ServletException;
import io.opentelemetry.testing.internal.servlet.ServletRequest;
import io.opentelemetry.testing.internal.servlet.ServletRequestEvent;
import io.opentelemetry.testing.internal.servlet.ServletRequestListener;
import io.opentelemetry.testing.internal.servlet.ServletResponse;
import io.opentelemetry.testing.internal.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PushSessionCacheFilter
implements Filter {
    private static final String TARGET_ATTR = "PushCacheFilter.target";
    private static final String TIMESTAMP_ATTR = "PushCacheFilter.timestamp";
    private static final Logger LOG = Log.getLogger(PushSessionCacheFilter.class);
    private final ConcurrentMap<String, Target> _cache = new ConcurrentHashMap<String, Target>();
    private long _associateDelay = 5000L;

    @Override
    public void init(FilterConfig config) throws ServletException {
        if (config.getInitParameter("associateDelay") != null) {
            this._associateDelay = Long.parseLong(config.getInitParameter("associateDelay"));
        }
        config.getServletContext().addListener(new ServletRequestListener(){

            @Override
            public void requestDestroyed(ServletRequestEvent sre) {
                String referer;
                Request request = Request.getBaseRequest(sre.getServletRequest());
                Target target = (Target)request.getAttribute(PushSessionCacheFilter.TARGET_ATTR);
                if (target == null) {
                    return;
                }
                Response response = request.getResponse();
                target._etag = response.getHttpFields().get(HttpHeader.ETAG);
                target._lastModified = response.getHttpFields().get(HttpHeader.LAST_MODIFIED);
                if (request.isPush()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pushed {} for {}", request.getResponse().getStatus(), request.getRequestURI());
                    }
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Served {} for {}", request.getResponse().getStatus(), request.getRequestURI());
                }
                if ((referer = request.getHttpFields().get(HttpHeader.REFERER)) != null) {
                    HttpSession session;
                    ConcurrentHashMap timestamps;
                    Long last;
                    Target refererTarget;
                    HttpURI refererUri = new HttpURI(referer);
                    if (request.getServerName().equals(refererUri.getHost()) && (refererTarget = (Target)PushSessionCacheFilter.this._cache.get(refererUri.getPath())) != null && (last = (Long)(timestamps = (ConcurrentHashMap)(session = request.getSession()).getAttribute(PushSessionCacheFilter.TIMESTAMP_ATTR)).get(refererTarget._path)) != null && System.currentTimeMillis() - last < PushSessionCacheFilter.this._associateDelay && refererTarget._associated.putIfAbsent(target._path, target) == null && LOG.isDebugEnabled()) {
                        LOG.debug("ASSOCIATE {}->{}", refererTarget._path, target._path);
                    }
                }
            }

            @Override
            public void requestInitialized(ServletRequestEvent sre) {
            }
        });
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Request baseRequest = Request.getBaseRequest(request);
        String uri = baseRequest.getRequestURI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} push={}", baseRequest.getMethod(), uri, baseRequest.isPush());
        }
        HttpSession session = baseRequest.getSession(true);
        Target target = (Target)this._cache.get(uri);
        if (target == null) {
            Target t = new Target(uri);
            target = this._cache.putIfAbsent(uri, t);
            target = target == null ? t : target;
        }
        request.setAttribute(TARGET_ATTR, target);
        ConcurrentHashMap<String, Long> timestamps = (ConcurrentHashMap<String, Long>)session.getAttribute(TIMESTAMP_ATTR);
        if (timestamps == null) {
            timestamps = new ConcurrentHashMap<String, Long>();
            session.setAttribute(TIMESTAMP_ATTR, timestamps);
        }
        timestamps.put(uri, System.currentTimeMillis());
        if (baseRequest.isPushSupported() && !baseRequest.isPush() && !target._associated.isEmpty()) {
            ArrayDeque<Target> queue = new ArrayDeque<Target>();
            queue.offer(target);
            while (!queue.isEmpty()) {
                Target parent = (Target)queue.poll();
                PushBuilder builder = baseRequest.getPushBuilder();
                builder.addHeader("X-Pusher", PushSessionCacheFilter.class.toString());
                for (Target child : parent._associated.values()) {
                    queue.offer(child);
                    String path = child._path;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PUSH {} <- {}", path, uri);
                    }
                    builder.path(path).etag(child._etag).lastModified(child._lastModified).push();
                }
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        this._cache.clear();
    }

    private static class Target {
        private final String _path;
        private final ConcurrentMap<String, Target> _associated = new ConcurrentHashMap<String, Target>();
        private volatile String _etag;
        private volatile String _lastModified;

        private Target(String path) {
            this._path = path;
        }

        public String toString() {
            return String.format("Target{p=%s,e=%s,m=%s,a=%d}", this._path, this._etag, this._lastModified, this._associated.size());
        }
    }
}

