/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server.handler;

import io.opentelemetry.testing.internal.jetty.server.HttpChannel;
import io.opentelemetry.testing.internal.jetty.server.HttpConfiguration;
import io.opentelemetry.testing.internal.jetty.server.Request;
import io.opentelemetry.testing.internal.jetty.server.handler.AbstractHandler;
import io.opentelemetry.testing.internal.jetty.util.URIUtil;
import io.opentelemetry.testing.internal.servlet.ServletException;
import io.opentelemetry.testing.internal.servlet.http.HttpServletRequest;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SecuredRedirectHandler
extends AbstractHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpChannel channel = baseRequest.getHttpChannel();
        if (baseRequest.isSecure() || channel == null) {
            return;
        }
        HttpConfiguration httpConfig = channel.getHttpConfiguration();
        if (httpConfig == null) {
            response.sendError(403, "No http configuration available");
            return;
        }
        if (httpConfig.getSecurePort() > 0) {
            String scheme = httpConfig.getSecureScheme();
            int port = httpConfig.getSecurePort();
            String url = URIUtil.newURI(scheme, baseRequest.getServerName(), port, baseRequest.getRequestURI(), baseRequest.getQueryString());
            response.setContentLength(0);
            baseRequest.getResponse().sendRedirect(302, url, true);
        } else {
            response.sendError(403, "Not Secure");
        }
        baseRequest.setHandled(true);
    }
}

