/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.server;

import io.opentelemetry.testing.internal.jetty.server.handler.ContextHandler;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import io.opentelemetry.testing.internal.jetty.util.resource.PathResource;
import io.opentelemetry.testing.internal.jetty.util.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

@Deprecated
public class SameFileAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(SameFileAliasChecker.class);

    @Override
    public boolean check(String uri, Resource resource) {
        if (File.separatorChar != '/' && uri.indexOf(File.separatorChar) >= 0) {
            return false;
        }
        if (!(resource instanceof PathResource)) {
            return false;
        }
        try {
            PathResource pathResource = (PathResource)resource;
            Path path = pathResource.getPath();
            Path alias = pathResource.getAliasPath();
            if (Files.isSameFile(path, alias)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow alias to same file {} --> {}", path, alias);
                }
                return true;
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
        return false;
    }
}

