/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.server;

import io.opentelemetry.testing.internal.jetty.http.BadMessageException;
import io.opentelemetry.testing.internal.jetty.http.HttpFields;
import io.opentelemetry.testing.internal.jetty.http.MetaData;
import io.opentelemetry.testing.internal.jetty.http2.server.HTTP2ServerConnection;
import io.opentelemetry.testing.internal.jetty.http2.server.HTTP2ServerConnectionFactory;
import io.opentelemetry.testing.internal.jetty.io.Connection;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.server.ConnectionFactory;
import io.opentelemetry.testing.internal.jetty.server.Connector;
import io.opentelemetry.testing.internal.jetty.server.HttpConfiguration;
import io.opentelemetry.testing.internal.jetty.util.annotation.Name;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;

public class HTTP2CServerConnectionFactory
extends HTTP2ServerConnectionFactory
implements ConnectionFactory.Upgrading {
    private static final Logger LOG = Log.getLogger(HTTP2CServerConnectionFactory.class);

    public HTTP2CServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2c");
    }

    public HTTP2CServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
        for (String p : protocols) {
            if (HTTP2ServerConnection.isSupportedProtocol(p)) continue;
            throw new IllegalArgumentException("Unsupported HTTP2 Protocol variant: " + p);
        }
    }

    @Override
    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        return false;
    }

    @Override
    public Connection upgradeConnection(Connector connector, EndPoint endPoint, MetaData.Request request, HttpFields response101) throws BadMessageException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgraded {}{}", this, request.toString(), request.getFields());
        }
        if (request.getContentLength() > 0L) {
            return null;
        }
        HTTP2ServerConnection connection = (HTTP2ServerConnection)this.newConnection(connector, endPoint);
        if (connection.upgrade(request)) {
            return connection;
        }
        return null;
    }
}

