/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.client;

import io.opentelemetry.testing.internal.jetty.client.HttpClient;
import io.opentelemetry.testing.internal.jetty.client.HttpRedirector;
import io.opentelemetry.testing.internal.jetty.client.ProtocolHandler;
import io.opentelemetry.testing.internal.jetty.client.api.Request;
import io.opentelemetry.testing.internal.jetty.client.api.Response;
import io.opentelemetry.testing.internal.jetty.client.api.Result;
import io.opentelemetry.testing.internal.jetty.http.HttpField;
import io.opentelemetry.testing.internal.jetty.http.HttpHeader;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        return field.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        if (result.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result.getFailure());
        }
    }
}

