/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.client;

import io.opentelemetry.testing.internal.jetty.client.AbstractConnectionPool;
import io.opentelemetry.testing.internal.jetty.client.ConnectionPool;
import io.opentelemetry.testing.internal.jetty.client.HttpDestination;
import io.opentelemetry.testing.internal.jetty.client.api.Connection;
import io.opentelemetry.testing.internal.jetty.util.Callback;
import io.opentelemetry.testing.internal.jetty.util.Pool;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedAttribute;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool {
    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, Callback requester, int maxMultiplex) {
        this(destination, maxConnections, false, requester, maxMultiplex);
    }

    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, boolean cache, Callback requester, int maxMultiplex) {
        this(destination, Pool.StrategyType.FIRST, maxConnections, cache, requester, maxMultiplex);
    }

    public MultiplexConnectionPool(HttpDestination destination, Pool.StrategyType strategy, int maxConnections, boolean cache, Callback requester, int maxMultiplex) {
        super(destination, new Pool<Connection>(strategy, maxConnections, cache){

            @Override
            protected int getMaxMultiplex(Connection connection) {
                int multiplex = connection instanceof ConnectionPool.Multiplexable ? ((ConnectionPool.Multiplexable)((Object)connection)).getMaxMultiplex() : super.getMaxMultiplex(connection);
                return multiplex > 0 ? multiplex : 1;
            }
        }, requester);
        this.setMaxMultiplex(maxMultiplex);
    }

    @Deprecated
    public MultiplexConnectionPool(HttpDestination destination, Pool<Connection> pool, Callback requester, int maxMultiplex) {
        super(destination, pool, requester);
        this.setMaxMultiplex(maxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The multiplexing factor of connections")
    public int getMaxMultiplex() {
        return super.getMaxMultiplex();
    }

    @Override
    public void setMaxMultiplex(int maxMultiplex) {
        super.setMaxMultiplex(maxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The maximum amount of times a connection is used before it gets closed")
    public int getMaxUsageCount() {
        return super.getMaxUsageCount();
    }

    @Override
    public void setMaxUsageCount(int maxUsageCount) {
        super.setMaxUsageCount(maxUsageCount);
    }
}

