/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.alpn.java.client;

import io.opentelemetry.testing.internal.jetty.alpn.client.ALPNClientConnection;
import io.opentelemetry.testing.internal.jetty.io.Connection;
import io.opentelemetry.testing.internal.jetty.io.ssl.ALPNProcessor;
import io.opentelemetry.testing.internal.jetty.io.ssl.SslConnection;
import io.opentelemetry.testing.internal.jetty.io.ssl.SslHandshakeListener;
import io.opentelemetry.testing.internal.jetty.util.JavaVersion;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class JDK9ClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(JDK9ClientALPNProcessor.class);

    @Override
    public void init() {
        if (JavaVersion.VERSION.getPlatform() < 9) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        Module module = sslEngine.getClass().getModule();
        return module != null && "java.base".equals(module.getName());
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        ALPNClientConnection alpn = (ALPNClientConnection)connection;
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List<String> protocols = alpn.getProtocols();
        sslParameters.setApplicationProtocols(protocols.toArray(new String[0]));
        sslEngine.setSSLParameters(sslParameters);
        ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener(new ALPNListener(alpn));
    }

    private static final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getSSLEngine().getApplicationProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected protocol {}", protocol);
            }
            this.alpnConnection.selected(protocol);
        }
    }
}

