/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.alpn.client;

import io.opentelemetry.testing.internal.jetty.io.ClientConnectionFactory;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.io.NegotiatingClientConnection;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public class ALPNClientConnection
extends NegotiatingClientConnection {
    private static final Logger LOG = Log.getLogger(ALPNClientConnection.class);
    private final List<String> protocols;

    public ALPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, List<String> protocols) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocols = protocols;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void selected(String protocol) {
        if (protocol == null || !this.protocols.contains(protocol)) {
            this.close();
        } else {
            super.completed();
        }
    }
}

