/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jackson.datatype.jdk8;

import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import io.opentelemetry.testing.internal.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalDouble;

public class OptionalDoubleSerializer
extends StdScalarSerializer<OptionalDouble> {
    private static final long serialVersionUID = 1L;
    static final OptionalDoubleSerializer INSTANCE = new OptionalDoubleSerializer();

    public OptionalDoubleSerializer() {
        super(OptionalDouble.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalDouble value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.DOUBLE);
        }
    }

    @Override
    public void serialize(OptionalDouble value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            gen.writeNumber(value.getAsDouble());
        } else {
            gen.writeNull();
        }
    }
}

