/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5;

import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.ByteToMessageDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DecoderException;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DecoderResult;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.DefaultSocks5PrivateAuthResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5PrivateAuthStatus;
import java.util.List;

public final class Socks5PrivateAuthResponseDecoder
extends ByteToMessageDecoder {
    private State state = State.INIT;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch (this.state) {
                case INIT: {
                    if (in.readableBytes() < 2) {
                        return;
                    }
                    byte version = in.readByte();
                    if (version != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + version + " (expected: 1)");
                    }
                    out.add(new DefaultSocks5PrivateAuthResponse(Socks5PrivateAuthStatus.valueOf(in.readByte())));
                    this.state = State.SUCCESS;
                    break;
                }
                case SUCCESS: {
                    int readableBytes = in.readableBytes();
                    if (readableBytes > 0) {
                        out.add(in.readRetainedSlice(readableBytes));
                    }
                    break;
                }
                case FAILURE: {
                    in.skipBytes(in.readableBytes());
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.state = State.FAILURE;
        DefaultSocks5PrivateAuthResponse m = new DefaultSocks5PrivateAuthResponse(Socks5PrivateAuthStatus.FAILURE);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
    }

    private static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

