/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5;

import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DecoderException;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DecoderResult;
import io.opentelemetry.testing.internal.io.netty.handler.codec.ReplayingDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.SocksVersion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import java.util.List;

public class Socks5InitialResponseDecoder
extends ReplayingDecoder<State> {
    public Socks5InitialResponseDecoder() {
        super(State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case INIT: {
                    byte version = in.readByte();
                    if (version != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version + " (expected: " + SocksVersion.SOCKS5.byteValue() + ')');
                    }
                    Socks5AuthMethod authMethod = Socks5AuthMethod.valueOf(in.readByte());
                    out.add(new DefaultSocks5InitialResponse(authMethod));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    out.add(in.readRetainedSlice(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.checkpoint(State.FAILURE);
        DefaultSocks5InitialResponse m = new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
    }

    public static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

