/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.handler.codec.http2;

import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Error;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Exception;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2LifecycleManager;
import io.opentelemetry.testing.internal.io.netty.util.internal.logging.InternalLogger;
import io.opentelemetry.testing.internal.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

final class Http2MaxRstFrameLimitEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2MaxRstFrameLimitEncoder.class);
    private final long nanosPerWindow;
    private final int maxRstFramesPerWindow;
    private long lastRstFrameNano = System.nanoTime();
    private int sendRstInWindow;
    private Http2LifecycleManager lifecycleManager;

    Http2MaxRstFrameLimitEncoder(Http2ConnectionEncoder delegate, int maxRstFramesPerWindow, int secondsPerWindow) {
        super(delegate);
        this.maxRstFramesPerWindow = maxRstFramesPerWindow;
        this.nanosPerWindow = TimeUnit.SECONDS.toNanos(secondsPerWindow);
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
        super.lifecycleManager(lifecycleManager);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        ChannelFuture future = super.writeRstStream(ctx, streamId, errorCode, promise);
        if (this.countRstFrameErrorCode(errorCode)) {
            long currentNano = System.nanoTime();
            if (currentNano - this.lastRstFrameNano >= this.nanosPerWindow) {
                this.lastRstFrameNano = currentNano;
                this.sendRstInWindow = 1;
            } else {
                ++this.sendRstInWindow;
                if (this.sendRstInWindow > this.maxRstFramesPerWindow) {
                    Http2Exception exception = Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of RST frames frames reached within %d seconds", this.maxRstFramesPerWindow, TimeUnit.NANOSECONDS.toSeconds(this.nanosPerWindow));
                    logger.debug("{} Maximum number {} of RST frames reached within {} seconds, closing connection with {} error", new Object[]{ctx.channel(), this.maxRstFramesPerWindow, TimeUnit.NANOSECONDS.toSeconds(this.nanosPerWindow), exception.error(), exception});
                    this.lifecycleManager.onError(ctx, true, exception);
                    ctx.close();
                }
            }
        }
        return future;
    }

    private boolean countRstFrameErrorCode(long errorCode) {
        return errorCode != Http2Error.CANCEL.code() && errorCode != Http2Error.NO_ERROR.code();
    }
}

