/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.channel.kqueue;

import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.DefaultSelectStrategyFactory;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandle;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandler;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandlerFactory;
import io.opentelemetry.testing.internal.io.netty.channel.IoOps;
import io.opentelemetry.testing.internal.io.netty.channel.IoRegistration;
import io.opentelemetry.testing.internal.io.netty.channel.SelectStrategy;
import io.opentelemetry.testing.internal.io.netty.channel.SelectStrategyFactory;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.AbstractKQueueChannel;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.KQueue;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.KQueueEventArray;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.KQueueIoEvent;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.KQueueIoHandle;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.KQueueIoOps;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.Native;
import io.opentelemetry.testing.internal.io.netty.channel.kqueue.NativeArrays;
import io.opentelemetry.testing.internal.io.netty.channel.unix.FileDescriptor;
import io.opentelemetry.testing.internal.io.netty.util.IntSupplier;
import io.opentelemetry.testing.internal.io.netty.util.collection.LongObjectHashMap;
import io.opentelemetry.testing.internal.io.netty.util.collection.LongObjectMap;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ThreadAwareExecutor;
import io.opentelemetry.testing.internal.io.netty.util.internal.ObjectUtil;
import io.opentelemetry.testing.internal.io.netty.util.internal.StringUtil;
import io.opentelemetry.testing.internal.io.netty.util.internal.logging.InternalLogger;
import io.opentelemetry.testing.internal.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class KQueueIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueIoHandler.class);
    private static final AtomicIntegerFieldUpdater<KQueueIoHandler> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueIoHandler.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final NativeArrays nativeArrays;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return KQueueIoHandler.this.kqueueWaitNow();
        }
    };
    private final ThreadAwareExecutor executor;
    private final Queue<DefaultKqueueIoRegistration> cancelledRegistrations = new ArrayDeque<DefaultKqueueIoRegistration>();
    private final LongObjectMap<DefaultKqueueIoRegistration> registrations = new LongObjectHashMap<DefaultKqueueIoRegistration>(4096);
    private int numChannels;
    private long nextId;
    private volatile int wakenUp;

    private long generateNextId() {
        boolean reset = false;
        do {
            if (this.nextId == Long.MAX_VALUE) {
                if (reset) {
                    throw new IllegalStateException("All possible ids in use");
                }
                reset = true;
            }
            ++this.nextId;
        } while (this.nextId == 0L || this.registrations.containsKey(this.nextId));
        return this.nextId;
    }

    public static IoHandlerFactory newFactory() {
        return KQueueIoHandler.newFactory(0, DefaultSelectStrategyFactory.INSTANCE);
    }

    public static IoHandlerFactory newFactory(int maxEvents, SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkPositiveOrZero(maxEvents, "maxEvents");
        ObjectUtil.checkNotNull(selectStrategyFactory, "selectStrategyFactory");
        return executor -> new KQueueIoHandler(executor, maxEvents, selectStrategyFactory.newSelectStrategy());
    }

    private KQueueIoHandler(ThreadAwareExecutor executor, int maxEvents, SelectStrategy strategy) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.selectStrategy = ObjectUtil.checkNotNull(strategy, "strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray(maxEvents);
        this.nativeArrays = new NativeArrays();
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            this.destroy();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -result);
        }
    }

    @Override
    public void wakeup() {
        if (!this.executor.isExecutorThread(Thread.currentThread()) && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup0();
        }
    }

    private void wakeup0() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(IoHandlerContext context, boolean oldWakeup) throws IOException {
        if (oldWakeup && !context.canBlock()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = context.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, 86399L);
        int delayNanos = (int)(totalDelay % 1000000000L);
        return this.kqueueWait(delaySeconds, delayNanos);
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, timeoutNs);
        this.changeList.clear();
        return numEvents;
    }

    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int ident = this.eventList.ident(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && ident == 0);
                continue;
            }
            long id = this.eventList.udata(i);
            DefaultKqueueIoRegistration registration = this.registrations.get(id);
            if (registration == null) {
                logger.warn("events[{}]=[{}, {}, {}] had no registration!", i, ident, id, filter);
                continue;
            }
            registration.handle(ident, filter, flags, this.eventList.fflags(i), this.eventList.data(i), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(IoHandlerContext context) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, !context.canBlock());
            switch (strategy) {
                case -2: {
                    int n = 0;
                    return n;
                }
                case -3: 
                case -1: {
                    strategy = this.kqueueWait(context, WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                    if (this.wakenUp != 1) break;
                    this.wakeup0();
                }
            }
            if (strategy > 0) {
                handled = strategy;
                this.processReady(strategy);
            }
            if (this.allowGrowing && strategy == this.eventList.capacity()) {
                this.eventList.realloc(false);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            KQueueIoHandler.handleLoopException(t);
        }
        finally {
            this.processCancelledRegistrations();
        }
        return handled;
    }

    private void processCancelledRegistrations() {
        DefaultKqueueIoRegistration cancelledRegistration;
        while ((cancelledRegistration = this.cancelledRegistrations.poll()) != null) {
            DefaultKqueueIoRegistration removed = this.registrations.remove(cancelledRegistration.id);
            assert (removed == cancelledRegistration);
            if (!removed.isHandleForChannel()) continue;
            --this.numChannels;
        }
        return;
    }

    int numRegisteredChannels() {
        return this.numChannels;
    }

    List<Channel> registeredChannelsList() {
        LongObjectMap<DefaultKqueueIoRegistration> ch = this.registrations;
        if (ch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(ch.size());
        for (DefaultKqueueIoRegistration registration : ch.values()) {
            if (!(registration.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe)) continue;
            channels.add(((AbstractKQueueChannel.AbstractKQueueUnsafe)registration.handle).channel());
        }
        return Collections.unmodifiableList(channels);
    }

    private static void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void prepareToDestroy() {
        DefaultKqueueIoRegistration[] copy;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (DefaultKqueueIoRegistration reg : copy = this.registrations.values().toArray(new DefaultKqueueIoRegistration[0])) {
            reg.close();
        }
        this.processCancelledRegistrations();
    }

    @Override
    public void destroy() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the kqueue fd.", e);
            }
        }
        finally {
            this.nativeArrays.free();
            this.changeList.free();
            this.eventList.free();
        }
    }

    @Override
    public IoRegistration register(IoHandle handle) {
        KQueueIoHandle kqueueHandle = KQueueIoHandler.cast(handle);
        if (kqueueHandle.ident() == 0) {
            throw new IllegalArgumentException("ident 0 is reserved for internal usage");
        }
        DefaultKqueueIoRegistration registration = new DefaultKqueueIoRegistration(this.executor, kqueueHandle);
        DefaultKqueueIoRegistration old = this.registrations.put(registration.id, registration);
        if (old != null) {
            this.registrations.put(old.id, old);
            throw new IllegalStateException();
        }
        if (registration.isHandleForChannel()) {
            ++this.numChannels;
        }
        return registration;
    }

    private static KQueueIoHandle cast(IoHandle handle) {
        if (handle instanceof KQueueIoHandle) {
            return (KQueueIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    private static KQueueIoOps cast(IoOps ops) {
        if (ops instanceof KQueueIoOps) {
            return (KQueueIoOps)ops;
        }
        throw new IllegalArgumentException("IoOps of type " + StringUtil.simpleClassName(ops) + " not supported");
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return KQueueIoHandle.class.isAssignableFrom(handleType);
    }

    static {
        KQueue.ensureAvailability();
    }

    private final class DefaultKqueueIoRegistration
    implements IoRegistration {
        private boolean cancellationPending;
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final KQueueIoEvent event = new KQueueIoEvent();
        final KQueueIoHandle handle;
        final long id;
        private final ThreadAwareExecutor executor;

        DefaultKqueueIoRegistration(ThreadAwareExecutor executor, KQueueIoHandle handle) {
            this.executor = executor;
            this.handle = handle;
            this.id = KQueueIoHandler.this.generateNextId();
        }

        boolean isHandleForChannel() {
            return this.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe;
        }

        @Override
        public <T> T attachment() {
            return (T)KQueueIoHandler.this.nativeArrays;
        }

        @Override
        public long submit(IoOps ops) {
            KQueueIoOps kQueueIoOps = KQueueIoHandler.cast(ops);
            if (!this.isValid()) {
                return -1L;
            }
            short filter = kQueueIoOps.filter();
            short flags = kQueueIoOps.flags();
            int fflags = kQueueIoOps.fflags();
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.evSet(filter, flags, fflags);
            } else {
                this.executor.execute(() -> this.evSet(filter, flags, fflags));
            }
            return 0L;
        }

        void handle(int ident, short filter, short flags, int fflags, long data, long udata) {
            if (this.cancellationPending) {
                return;
            }
            this.event.update(ident, filter, flags, fflags, data, udata);
            this.handle.handle(this, this.event);
        }

        private void evSet(short filter, short flags, int fflags) {
            if (this.cancellationPending) {
                return;
            }
            KQueueIoHandler.this.changeList.evSet(this.handle.ident(), filter, flags, fflags, 0L, this.id);
        }

        @Override
        public boolean isValid() {
            return !this.canceled.get();
        }

        @Override
        public boolean cancel() {
            if (!this.canceled.compareAndSet(false, true)) {
                return false;
            }
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
            return true;
        }

        private void cancel0() {
            this.cancellationPending = true;
            KQueueIoHandler.this.cancelledRegistrations.offer(this);
        }

        void close() {
            this.cancel();
            try {
                this.handle.close();
            }
            catch (Exception e) {
                logger.debug("Exception during closing " + this.handle, e);
            }
        }
    }
}

