/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.logging;

import io.opentelemetry.testing.internal.io.micrometer.common.lang.NonNullApi;
import io.opentelemetry.testing.internal.io.micrometer.common.lang.NonNullFields;
import io.opentelemetry.testing.internal.io.micrometer.common.util.internal.logging.InternalLogger;
import io.opentelemetry.testing.internal.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Counter;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Tag;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.MeterBinder;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.CompositeFilter;

@NonNullApi
@NonNullFields
public class Log4j2Metrics
implements MeterBinder,
AutoCloseable {
    private static final String METER_NAME = "log4j2.events";
    private static final String METER_DESCRIPTION = "Number of log events";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Log4j2Metrics.class);
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private final ConcurrentMap<MeterRegistry, MetricsFilter> metricsFilters = new ConcurrentHashMap<MeterRegistry, MetricsFilter>();
    private final List<PropertyChangeListener> changeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public Log4j2Metrics() {
        this(Collections.emptyList());
    }

    public Log4j2Metrics(Iterable<Tag> tags) {
        this(tags, (LoggerContext)LogManager.getContext((boolean)false));
    }

    public Log4j2Metrics(Iterable<Tag> tags, LoggerContext loggerContext) {
        this.tags = tags;
        this.loggerContext = loggerContext;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.metricsFilters.containsKey(registry)) {
            logger.warn("This Log4j2Metrics instance has already been bound to the registry {}", (Object)registry);
            return;
        }
        Configuration configuration = this.loggerContext.getConfiguration();
        this.registerMetricsFilter(configuration, registry);
        this.loggerContext.updateLoggers(configuration);
        PropertyChangeListener changeListener = listener -> {
            if (listener.getNewValue() instanceof Configuration) {
                Configuration newConfiguration = (Configuration)listener.getNewValue();
                if (this.registerMetricsFilter(newConfiguration, registry)) {
                    this.loggerContext.updateLoggers(newConfiguration);
                }
                if (listener.getOldValue() != listener.getNewValue() && listener.getOldValue() instanceof Configuration) {
                    this.removeMetricsFilter((Configuration)listener.getOldValue());
                }
            }
        };
        this.changeListeners.add(changeListener);
        this.loggerContext.addPropertyChangeListener(changeListener);
    }

    private boolean registerMetricsFilter(Configuration configuration, MeterRegistry registry) {
        MetricsFilter metricsFilter = this.getOrCreateMetricsFilterAndStart(registry);
        LoggerConfig rootLoggerConfig = configuration.getRootLogger();
        boolean changed = this.addFilterIfAbsent(rootLoggerConfig, metricsFilter);
        for (LoggerConfig loggerConfig : configuration.getLoggers().values()) {
            if (loggerConfig == rootLoggerConfig || loggerConfig.isAdditive()) continue;
            changed |= this.addFilterIfAbsent(loggerConfig, metricsFilter);
        }
        return changed;
    }

    private boolean addFilterIfAbsent(LoggerConfig loggerConfig, MetricsFilter metricsFilter) {
        Filter existingFilter = loggerConfig.getFilter();
        if (existingFilter == metricsFilter || existingFilter instanceof CompositeFilter && Arrays.asList(((CompositeFilter)existingFilter).getFiltersArray()).contains((Object)metricsFilter)) {
            return false;
        }
        loggerConfig.addFilter((Filter)metricsFilter);
        return true;
    }

    private MetricsFilter getOrCreateMetricsFilterAndStart(MeterRegistry registry) {
        return this.metricsFilters.computeIfAbsent(registry, r -> {
            MetricsFilter metricsFilter = new MetricsFilter((MeterRegistry)r, this.tags);
            metricsFilter.start();
            return metricsFilter;
        });
    }

    @Override
    public void close() {
        this.changeListeners.forEach(arg_0 -> ((LoggerContext)this.loggerContext).removePropertyChangeListener(arg_0));
        this.changeListeners.clear();
        if (!this.metricsFilters.isEmpty()) {
            Configuration configuration = this.loggerContext.getConfiguration();
            this.removeMetricsFilter(configuration);
            this.loggerContext.updateLoggers(configuration);
            this.metricsFilters.values().forEach(AbstractLifeCycle::stop);
            this.metricsFilters.clear();
        }
    }

    private void removeMetricsFilter(Configuration configuration) {
        LoggerConfig rootLoggerConfig = configuration.getRootLogger();
        this.metricsFilters.values().forEach(arg_0 -> ((LoggerConfig)rootLoggerConfig).removeFilter(arg_0));
        configuration.getLoggers().values().stream().filter(loggerConfig -> !loggerConfig.isAdditive()).forEach(loggerConfig -> {
            if (loggerConfig != rootLoggerConfig) {
                this.metricsFilters.values().forEach(arg_0 -> ((LoggerConfig)loggerConfig).removeFilter(arg_0));
            }
        });
    }

    @NonNullApi
    @NonNullFields
    static class MetricsFilter
    extends AbstractFilter {
        private final Counter fatalCounter;
        private final Counter errorCounter;
        private final Counter warnCounter;
        private final Counter infoCounter;
        private final Counter debugCounter;
        private final Counter traceCounter;

        MetricsFilter(MeterRegistry registry, Iterable<Tag> tags) {
            this.fatalCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "fatal").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
            this.errorCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "error").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
            this.warnCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "warn").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
            this.infoCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "info").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
            this.debugCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "debug").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
            this.traceCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(tags).tags("level", "trace").description(Log4j2Metrics.METER_DESCRIPTION).baseUnit("events").register(registry);
        }

        public Filter.Result filter(LogEvent event) {
            this.incrementCounter(event);
            return Filter.Result.NEUTRAL;
        }

        private void incrementCounter(LogEvent event) {
            switch (event.getLevel().getStandardLevel()) {
                case FATAL: {
                    this.fatalCounter.increment();
                    break;
                }
                case ERROR: {
                    this.errorCounter.increment();
                    break;
                }
                case WARN: {
                    this.warnCounter.increment();
                    break;
                }
                case INFO: {
                    this.infoCounter.increment();
                    break;
                }
                case DEBUG: {
                    this.debugCounter.increment();
                    break;
                }
                case TRACE: {
                    this.traceCounter.increment();
                    break;
                }
            }
        }
    }
}

