/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc;

import io.opentelemetry.testing.internal.io.micrometer.common.KeyValue;
import io.opentelemetry.testing.internal.io.micrometer.common.KeyValues;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationConvention;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;

public class DefaultGrpcClientObservationConvention
implements GrpcClientObservationConvention {
    private static final KeyValue STATUS_CODE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue("UNKNOWN");
    private static final KeyValue PEER_PORT_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue("UNKNOWN");

    @Override
    public String getName() {
        return "grpc.client";
    }

    @Override
    public String getContextualName(GrpcClientObservationContext context) {
        return context.getFullMethodName();
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(GrpcClientObservationContext context) {
        KeyValue statusCodeKeyValue = context.getStatusCode() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue(context.getStatusCode().name()) : STATUS_CODE_UNKNOWN;
        KeyValue peerPortKeyValue = context.getPeerPort() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue(context.getPeerPort().toString()) : PEER_PORT_UNKNOWN;
        return KeyValues.of(statusCodeKeyValue, GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue(context.getPeerName()), peerPortKeyValue, GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(context.getMethodName()), GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue(context.getServiceName()), GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD_TYPE.withValue(context.getMethodType().name()));
    }
}

