/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.context;

import io.opentelemetry.testing.internal.io.micrometer.context.ContextRegistry;
import io.opentelemetry.testing.internal.io.micrometer.context.DefaultContextSnapshotFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface ContextSnapshot {
    public <C> C updateContext(C var1);

    public <C> C updateContext(C var1, Predicate<Object> var2);

    public Scope setThreadLocals();

    public Scope setThreadLocals(Predicate<Object> var1);

    default public Runnable wrap(Runnable runnable) {
        return () -> {
            try (Scope scope = this.setThreadLocals();){
                runnable.run();
            }
        };
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try (Scope scope = this.setThreadLocals();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public <T> Consumer<T> wrap(Consumer<T> consumer) {
        return value -> {
            try (Scope scope = this.setThreadLocals();){
                consumer.accept(value);
            }
        };
    }

    default public Executor wrapExecutor(Executor executor) {
        return runnable -> {
            Runnable instrumentedRunnable = this.wrap(runnable);
            executor.execute(instrumentedRunnable);
        };
    }

    @Deprecated
    public static ContextSnapshot captureAll(Object ... contexts) {
        return ContextSnapshot.captureAll(ContextRegistry.getInstance(), contexts);
    }

    @Deprecated
    public static ContextSnapshot captureAll(ContextRegistry registry, Object ... contexts) {
        return ContextSnapshot.captureAllUsing(key -> true, registry, contexts);
    }

    @Deprecated
    public static ContextSnapshot captureAllUsing(Predicate<Object> keyPredicate, ContextRegistry registry, Object ... contexts) {
        return DefaultContextSnapshotFactory.captureAll(registry, keyPredicate, false, contexts);
    }

    @Deprecated
    public static ContextSnapshot captureFrom(Object context) {
        return ContextSnapshot.captureFrom(context, ContextRegistry.getInstance());
    }

    @Deprecated
    public static ContextSnapshot captureFrom(Object context, ContextRegistry registry) {
        return DefaultContextSnapshotFactory.captureFromContext(key -> true, false, registry, null, context);
    }

    @Deprecated
    public static ContextSnapshot captureFrom(Object context, Predicate<Object> keyPredicate, ContextRegistry registry) {
        return DefaultContextSnapshotFactory.captureFromContext(keyPredicate, false, registry, null, context);
    }

    @Deprecated
    public static Scope setAllThreadLocalsFrom(Object sourceContext) {
        return DefaultContextSnapshotFactory.setAllThreadLocalsFrom(sourceContext, ContextRegistry.getInstance(), false);
    }

    @Deprecated
    public static Scope setAllThreadLocalsFrom(Object sourceContext, ContextRegistry contextRegistry) {
        return DefaultContextSnapshotFactory.setAllThreadLocalsFrom(sourceContext, contextRegistry, false);
    }

    @Deprecated
    public static Scope setThreadLocalsFrom(Object sourceContext, String ... keys) {
        return ContextSnapshot.setThreadLocalsFrom(sourceContext, ContextRegistry.getInstance(), keys);
    }

    @Deprecated
    public static Scope setThreadLocalsFrom(Object sourceContext, ContextRegistry contextRegistry, String ... keys) {
        return DefaultContextSnapshotFactory.setThreadLocalsFrom(sourceContext, contextRegistry, false, keys);
    }

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

