/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.RpcResponse;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.RpcService;
import io.opentelemetry.testing.internal.armeria.server.throttling.AbstractThrottlingServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingAcceptHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingRejectHandler;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingRpcService;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.function.Function;

public final class ThrottlingRpcServiceBuilder
extends AbstractThrottlingServiceBuilder<RpcRequest, RpcResponse> {
    private static final ThrottlingRejectHandler<RpcRequest, RpcResponse> DEFAULT_REJECT_HANDLER = (delegate, ctx, req, cause) -> RpcResponse.ofFailure(HttpStatusException.of(HttpStatus.SERVICE_UNAVAILABLE));

    ThrottlingRpcServiceBuilder(ThrottlingStrategy<RpcRequest> strategy) {
        super(strategy, DEFAULT_REJECT_HANDLER);
    }

    public ThrottlingRpcServiceBuilder onAcceptedRequest(ThrottlingAcceptHandler<RpcRequest, RpcResponse> acceptHandler) {
        this.setAcceptHandler(acceptHandler);
        return this;
    }

    public ThrottlingRpcServiceBuilder onRejectedRequest(ThrottlingRejectHandler<RpcRequest, RpcResponse> rejectHandler) {
        this.setRejectHandler(rejectHandler);
        return this;
    }

    public ThrottlingRpcService build(RpcService delegate) {
        return new ThrottlingRpcService(Objects.requireNonNull(delegate, "delegate"), this.getStrategy(), this.getAcceptHandler(), this.getRejectHandler());
    }

    public Function<? super RpcService, ThrottlingRpcService> newDecorator() {
        ThrottlingStrategy strategy = this.getStrategy();
        ThrottlingAcceptHandler acceptHandler = this.getAcceptHandler();
        ThrottlingRejectHandler rejectHandler = this.getRejectHandler();
        return service -> new ThrottlingRpcService((RpcService)service, strategy, acceptHandler, rejectHandler);
    }
}

