/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.streaming;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.sse.ServerSentEvent;
import io.opentelemetry.testing.internal.armeria.internal.server.ResponseConversionUtil;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerSentEvents {
    private static final Logger logger = LoggerFactory.getLogger(ServerSentEvents.class);
    private static boolean warnedStatusCode;
    private static boolean warnedContentType;
    private static final char LINE_FEED = '\n';
    private static final ResponseHeaders defaultHttpHeaders;

    public static HttpResponse fromPublisher(Publisher<? extends ServerSentEvent> contentPublisher) {
        return ServerSentEvents.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of());
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<? extends ServerSentEvent> contentPublisher) {
        return ServerSentEvents.fromPublisher(headers, contentPublisher, HttpHeaders.of());
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<? extends ServerSentEvent> contentPublisher, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(contentPublisher, "contentPublisher");
        Objects.requireNonNull(trailers, "trailers");
        return ResponseConversionUtil.streamingFrom(contentPublisher, ServerSentEvents.sanitizeHeaders(headers), trailers, ServerSentEvents::toHttpData);
    }

    public static <T> HttpResponse fromPublisher(Publisher<T> contentPublisher, Function<? super T, ? extends ServerSentEvent> converter) {
        return ServerSentEvents.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of(), converter);
    }

    public static <T> HttpResponse fromPublisher(ResponseHeaders headers, Publisher<T> contentPublisher, Function<? super T, ? extends ServerSentEvent> converter) {
        return ServerSentEvents.fromPublisher(headers, contentPublisher, HttpHeaders.of(), converter);
    }

    public static <T> HttpResponse fromPublisher(ResponseHeaders headers, Publisher<T> contentPublisher, HttpHeaders trailers, Function<? super T, ? extends ServerSentEvent> converter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(contentPublisher, "contentPublisher");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(converter, "converter");
        return ResponseConversionUtil.streamingFrom(contentPublisher, ServerSentEvents.sanitizeHeaders(headers), trailers, o -> ServerSentEvents.toHttpData(converter, o));
    }

    public static HttpResponse fromStream(Stream<? extends ServerSentEvent> contentStream, Executor executor) {
        return ServerSentEvents.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<? extends ServerSentEvent> contentStream, Executor executor) {
        return ServerSentEvents.fromStream(headers, contentStream, HttpHeaders.of(), executor);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<? extends ServerSentEvent> contentStream, HttpHeaders trailers, Executor executor) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(contentStream, "contentStream");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(executor, "executor");
        return ResponseConversionUtil.streamingFrom(contentStream, ServerSentEvents.sanitizeHeaders(headers), trailers, ServerSentEvents::toHttpData, executor);
    }

    public static <T> HttpResponse fromStream(Stream<T> contentStream, Executor executor, Function<? super T, ? extends ServerSentEvent> converter) {
        return ServerSentEvents.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor, converter);
    }

    public static <T> HttpResponse fromStream(ResponseHeaders headers, Stream<T> contentStream, Executor executor, Function<? super T, ? extends ServerSentEvent> converter) {
        return ServerSentEvents.fromStream(headers, contentStream, HttpHeaders.of(), executor, converter);
    }

    public static <T> HttpResponse fromStream(ResponseHeaders headers, Stream<T> contentStream, HttpHeaders trailers, Executor executor, Function<? super T, ? extends ServerSentEvent> converter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(contentStream, "contentStream");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(converter, "converter");
        return ResponseConversionUtil.streamingFrom(contentStream, ServerSentEvents.sanitizeHeaders(headers), trailers, o -> ServerSentEvents.toHttpData(converter, o), executor);
    }

    public static HttpResponse fromEvent(ServerSentEvent sse) {
        return ServerSentEvents.fromEvent(defaultHttpHeaders, sse, HttpHeaders.of());
    }

    public static HttpResponse fromEvent(ResponseHeaders headers, ServerSentEvent sse) {
        return ServerSentEvents.fromEvent(headers, sse, HttpHeaders.of());
    }

    public static HttpResponse fromEvent(ResponseHeaders headers, ServerSentEvent sse, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(sse, "sse");
        Objects.requireNonNull(trailers, "trailers");
        return HttpResponse.of(ServerSentEvents.sanitizeHeaders(headers), ServerSentEvents.toHttpData(sse), trailers);
    }

    private static ResponseHeaders sanitizeHeaders(ResponseHeaders headers) {
        if (headers == defaultHttpHeaders) {
            return headers;
        }
        return ServerSentEvents.ensureContentType(ServerSentEvents.ensureHttpStatus(headers));
    }

    static ResponseHeaders ensureHttpStatus(ResponseHeaders headers) {
        HttpStatus status = headers.status();
        if (status.equals(HttpStatus.OK)) {
            return headers;
        }
        if (!warnedStatusCode) {
            logger.warn("Overwriting the HTTP status code from '{}' to '{}' for Server-Sent Events. Do not set an HTTP status code on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its status code. Please refer to https://www.w3.org/TR/eventsource/ for more information.", new Object[]{status, HttpStatus.OK, ServerSentEvents.class.getSimpleName(), HttpStatus.OK});
            warnedStatusCode = true;
        }
        return headers.toBuilder().status(HttpStatus.OK).build();
    }

    static ResponseHeaders ensureContentType(ResponseHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType == null) {
            return headers.toBuilder().contentType(MediaType.EVENT_STREAM).build();
        }
        if (contentType.is(MediaType.EVENT_STREAM)) {
            return headers;
        }
        if (!warnedContentType) {
            logger.warn("Overwriting content-type from '{}' to '{}' for Server-Sent Events. Do not set a content-type on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its content-type. Please refer to https://www.w3.org/TR/eventsource/ for more information.", new Object[]{contentType, MediaType.EVENT_STREAM, ServerSentEvents.class.getSimpleName(), MediaType.EVENT_STREAM});
            warnedContentType = true;
        }
        return headers.toBuilder().contentType(MediaType.EVENT_STREAM).build();
    }

    private static HttpData toHttpData(ServerSentEvent sse) {
        Duration retry;
        String data;
        String event;
        String id;
        StringBuilder sb = new StringBuilder();
        String comment = sse.comment();
        if (comment != null) {
            ServerSentEvents.appendField(sb, "", comment, false);
        }
        if ((id = sse.id()) != null) {
            ServerSentEvents.appendField(sb, "id", id, true);
        }
        if ((event = sse.event()) != null) {
            ServerSentEvents.appendField(sb, "event", event, true);
        }
        if ((data = sse.data()) != null) {
            ServerSentEvents.appendField(sb, "data", data, true);
        }
        if ((retry = sse.retry()) != null) {
            sb.append("retry:").append(retry.toMillis()).append('\n');
        }
        return sb.length() == 0 ? HttpData.empty() : HttpData.ofUtf8(sb.append('\n').toString());
    }

    private static <T> HttpData toHttpData(Function<? super T, ? extends ServerSentEvent> converter, T content) {
        ServerSentEvent sse = converter.apply(content);
        return sse == null ? HttpData.empty() : ServerSentEvents.toHttpData(sse);
    }

    private static void appendField(StringBuilder sb, String name, String value, boolean emitFieldForEmptyValue) {
        if (value.isEmpty()) {
            if (emitFieldForEmptyValue) {
                sb.append(name).append('\n');
            }
        } else {
            sb.append(name).append(':');
            String[] values = value.split("\n");
            assert (values.length > 0);
            if (values.length == 1) {
                sb.append(value);
            } else {
                int len = values.length - 1;
                for (int i = 0; i < len; ++i) {
                    sb.append(values[i]).append('\n').append(name).append(':');
                }
                sb.append(values[len]);
            }
            sb.append('\n');
        }
    }

    private ServerSentEvents() {
    }

    static {
        defaultHttpHeaders = ResponseHeaders.builder(HttpStatus.OK).contentType(MediaType.EVENT_STREAM).build();
    }
}

