/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.management;

import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.stream.Collectors;

enum ThreadDumpService implements HttpService
{
    INSTANCE;


    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        boolean acceptJson = req.headers().accept().stream().anyMatch(MediaType.JSON::is);
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        if (acceptJson) {
            return HttpResponse.ofJson(threadInfos);
        }
        String threadDump = Arrays.stream(threadInfos).map(ThreadInfo::toString).collect(Collectors.joining());
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT, threadDump);
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.UNARY;
    }
}

