/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.ByteBufAccessMode;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.file.AbstractHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileAttributes;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DateFormatter;
import java.time.Clock;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

final class HttpDataFile
extends AbstractHttpFile
implements AggregatedHttpFile {
    private final HttpData content;
    private final HttpFileAttributes attrs;
    @Nullable
    private UnmodifiableFuture<AggregatedHttpFile> aggregateFuture;

    HttpDataFile(HttpData content, Clock clock, long lastModifiedMillis, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders headers) {
        this(content, null, clock, new HttpFileAttributes(content.length(), lastModifiedMillis), dateEnabled, lastModifiedEnabled, entityTagFunction, headers);
    }

    private HttpDataFile(HttpData content, @Nullable MediaType contentType, Clock clock, HttpFileAttributes attrs, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders headers) {
        super(contentType, clock, dateEnabled, lastModifiedEnabled, entityTagFunction, headers);
        this.content = Objects.requireNonNull(content, "content");
        this.attrs = Objects.requireNonNull(attrs, "attrs");
    }

    @Override
    protected String pathOrUri() {
        return "";
    }

    @Override
    @Nonnull
    public HttpFileAttributes attributes() {
        return this.attrs;
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(this.attrs);
    }

    @Override
    @Nonnull
    public ResponseHeaders headers() {
        ResponseHeaders headers = this.readHeaders(this.attrs);
        assert (headers != null);
        return headers;
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(this.headers());
    }

    @Override
    protected HttpResponse doRead(ResponseHeaders headers, long length, Executor fileReadExecutor, ByteBufAllocator alloc) {
        if (this.content.isPooled()) {
            ByteBuf buf = this.content.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE);
            return HttpResponse.of(headers, HttpData.wrap(buf));
        }
        return HttpResponse.of(headers, this.content);
    }

    @Override
    @Nonnull
    public HttpData content() {
        return this.content;
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return this.aggregate();
    }

    private UnmodifiableFuture<AggregatedHttpFile> aggregate() {
        if (this.aggregateFuture == null) {
            this.aggregateFuture = UnmodifiableFuture.completedFuture(this);
        }
        return this.aggregateFuture;
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.aggregate();
    }

    @Override
    public HttpFile toHttpFile() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("content", this.content()).add("contentType", this.contentType()).add("lastModified", DateFormatter.format(new Date(this.attrs.lastModifiedMillis()))).add("dateEnabled", this.isDateEnabled()).add("lastModifiedEnabled", this.isLastModifiedEnabled()).add("additionalHeaders", this.additionalHeaders()).toString();
    }
}

