/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteUtil;
import io.opentelemetry.testing.internal.armeria.server.file.AbstractBlockingHttpVfs;
import io.opentelemetry.testing.internal.armeria.server.file.FileSystemHttpVfs;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileBuilder;
import io.opentelemetry.testing.internal.armeria.server.file.MediaTypeResolver;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.Executor;

final class ClassPathHttpVfs
extends AbstractBlockingHttpVfs {
    private final ClassLoader classLoader;
    private final String rootDir;

    ClassPathHttpVfs(ClassLoader classLoader, String rootDir) {
        super(false);
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        this.rootDir = ClassPathHttpVfs.normalizeRootDir(rootDir);
    }

    private static String normalizeRootDir(String rootDir) {
        Objects.requireNonNull(rootDir, "rootDir");
        if (rootDir.startsWith("/")) {
            rootDir = rootDir.substring(1);
        }
        if (rootDir.endsWith("/")) {
            rootDir = rootDir.substring(0, rootDir.length() - 1);
        }
        return rootDir;
    }

    @Override
    protected HttpFile blockingGet(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
        RouteUtil.ensureAbsolutePath(path, "path");
        String resourcePath = this.rootDir.isEmpty() ? path.substring(1) : this.rootDir + path;
        HttpFileBuilder builder = HttpFile.builder(this.classLoader, resourcePath);
        return FileSystemHttpVfs.build(builder, clock, path, contentEncoding, additionalHeaders, mediaTypeResolver);
    }

    @Override
    public String meterTag() {
        return "classpath:" + this.rootDir;
    }
}

