/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileAttributes;
import io.opentelemetry.testing.internal.armeria.server.file.MediaTypeResolver;
import io.opentelemetry.testing.internal.armeria.server.file.StreamingHttpFile;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

final class ClassPathHttpFile
extends StreamingHttpFile<InputStream> {
    private final URL url;
    @Nullable
    private CompletableFuture<HttpFileAttributes> attrsFuture;

    ClassPathHttpFile(URL url, boolean contentTypeAutoDetectionEnabled, Clock clock, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders headers) {
        super(contentTypeAutoDetectionEnabled ? MediaTypeResolver.ofDefault().guessFromPath(url.toString(), null) : null, clock, dateEnabled, lastModifiedEnabled, entityTagFunction, headers);
        this.url = Objects.requireNonNull(url, "url");
    }

    @Override
    protected String pathOrUri() {
        return this.url.toString();
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        if (this.attrsFuture != null) {
            return this.attrsFuture;
        }
        this.attrsFuture = CompletableFuture.supplyAsync(() -> {
            try {
                URLConnection conn = this.url.openConnection();
                long length = conn.getContentLengthLong();
                long lastModifiedMillis = conn.getLastModified();
                return new HttpFileAttributes(length, lastModifiedMillis);
            }
            catch (IOException e) {
                return (HttpFileAttributes)Exceptions.throwUnsafely(e);
            }
        }, fileReadExecutor);
        return this.attrsFuture;
    }

    @Override
    protected InputStream newStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    protected int read(InputStream src, ByteBuf dst) throws IOException {
        return dst.writeBytes(src, dst.writableBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("url", this.url).add("contentType", this.contentType()).add("dateEnabled", this.isDateEnabled()).add("lastModifiedEnabled", this.isLastModifiedEnabled()).add("additionalHeaders", this.additionalHeaders()).toString();
    }
}

