/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.server.docs.ContainerTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptionInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptiveTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.EndpointInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.MethodInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignatureType;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class ServiceInfo {
    private final String name;
    private final Set<MethodInfo> methods;
    private final List<HttpHeaders> exampleHeaders;
    private final DescriptionInfo descriptionInfo;

    public ServiceInfo(String name, Iterable<MethodInfo> methods) {
        this(name, methods, DescriptionInfo.empty());
    }

    public ServiceInfo(String name, Iterable<MethodInfo> methods, DescriptionInfo descriptionInfo) {
        this(name, methods, ImmutableList.of(), descriptionInfo);
    }

    public ServiceInfo(String name, Iterable<MethodInfo> methods, Iterable<HttpHeaders> exampleHeaders, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.methods = ServiceInfo.mergeEndpoints(Objects.requireNonNull(methods));
        this.exampleHeaders = ImmutableList.copyOf(Objects.requireNonNull(exampleHeaders, "exampleHeaders"));
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Set<MethodInfo> methods() {
        return this.methods;
    }

    public ServiceInfo withMethods(Iterable<MethodInfo> methods) {
        Objects.requireNonNull(methods, "methods");
        if (methods.equals(this.methods)) {
            return this;
        }
        return new ServiceInfo(this.name, methods, this.exampleHeaders, this.descriptionInfo);
    }

    static Set<MethodInfo> mergeEndpoints(Iterable<MethodInfo> methodInfos) {
        HashMap<String, MethodInfo> methodInfoMap = new HashMap<String, MethodInfo>();
        for (MethodInfo methodInfo : methodInfos) {
            methodInfoMap.compute(methodInfo.id(), (key, value) -> {
                if (value == null) {
                    return methodInfo;
                }
                Sets.SetView<EndpointInfo> endpointInfos = Sets.union(value.endpoints(), methodInfo.endpoints());
                return new MethodInfo(value.name(), value.returnTypeSignature(), value.parameters(), value.useParameterAsRoot(), value.exceptionTypeSignatures(), endpointInfos, value.exampleHeaders(), value.exampleRequests(), value.examplePaths(), value.exampleQueries(), value.httpMethod(), value.descriptionInfo(), value.id());
            });
        }
        return ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(Comparator.comparing(MethodInfo::name).thenComparing(MethodInfo::httpMethod).thenComparing(MethodInfo::id)).addAll((Iterable)methodInfoMap.values())).build();
    }

    public Set<DescriptiveTypeSignature> findDescriptiveTypes() {
        Set<DescriptiveTypeSignature> requestDescriptiveTypes = this.findDescriptiveTypes(true);
        Set<DescriptiveTypeSignature> responseDescriptiveType = this.findDescriptiveTypes(false);
        int estimatedSize = requestDescriptiveTypes.size() + responseDescriptiveType.size();
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builderWithExpectedSize(estimatedSize).addAll(requestDescriptiveTypes)).addAll(responseDescriptiveType)).build();
    }

    public Set<DescriptiveTypeSignature> findDescriptiveTypes(boolean request) {
        HashSet collectedDescriptiveTypes = new HashSet();
        this.methods().forEach(m -> {
            if (request) {
                m.parameters().forEach(p -> ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, p.typeSignature()));
            } else {
                ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, m.returnTypeSignature());
                m.exceptionTypeSignatures().forEach(s -> ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, s));
            }
        });
        return ImmutableSet.copyOf(collectedDescriptiveTypes);
    }

    static void findDescriptiveTypes(Set<DescriptiveTypeSignature> collectedDescriptiveTypes, TypeSignature typeSignature) {
        TypeSignatureType type = typeSignature.type();
        if (type.hasTypeDescriptor()) {
            collectedDescriptiveTypes.add((DescriptiveTypeSignature)typeSignature);
            return;
        }
        if (typeSignature instanceof ContainerTypeSignature) {
            ((ContainerTypeSignature)typeSignature).typeParameters().forEach(p -> ServiceInfo.findDescriptiveTypes(collectedDescriptiveTypes, p));
        }
    }

    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public ServiceInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new ServiceInfo(this.name, this.methods, this.exampleHeaders, descriptionInfo);
    }

    @JsonProperty
    public List<HttpHeaders> exampleHeaders() {
        return this.exampleHeaders;
    }

    public ServiceInfo withExampleHeaders(Iterable<HttpHeaders> exampleHeaders) {
        Objects.requireNonNull(exampleHeaders, "exampleHeaders");
        if (exampleHeaders.equals(this.exampleHeaders)) {
            return this;
        }
        return new ServiceInfo(this.name, this.methods, exampleHeaders, this.descriptionInfo);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        return this.name.equals(that.name) && this.methods.equals(that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("methods", this.methods).add("exampleHeaders", this.exampleHeaders).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

