/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.opentelemetry.testing.internal.armeria.server.docs.EndpointInfoBuilder;
import io.opentelemetry.testing.internal.jackson.annotation.JsonInclude;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@UnstableApi
public final class EndpointInfo {
    private final String hostnamePattern;
    private final String pathMapping;
    @Nullable
    private final String regexPathPrefix;
    @Nullable
    private final String fragment;
    @Nullable
    private final MediaType defaultMimeType;
    private final Set<MediaType> availableMimeTypes;

    public static EndpointInfoBuilder builder(String hostnamePattern, String pathMapping) {
        return new EndpointInfoBuilder(hostnamePattern, pathMapping);
    }

    EndpointInfo(String hostnamePattern, String pathMapping, @Nullable String regexPathPrefix, @Nullable String fragment, @Nullable MediaType defaultMimeType, Iterable<MediaType> availableMimeTypes) {
        this.hostnamePattern = Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
        this.regexPathPrefix = Strings.emptyToNull(regexPathPrefix);
        this.fragment = Strings.emptyToNull(fragment);
        this.defaultMimeType = defaultMimeType;
        this.availableMimeTypes = ImmutableSortedSet.copyOf(Comparator.comparing(MediaType::toString), Objects.requireNonNull(availableMimeTypes, "availableMimeTypes"));
    }

    @JsonProperty
    public String hostnamePattern() {
        return this.hostnamePattern;
    }

    @JsonProperty
    public String pathMapping() {
        return this.pathMapping;
    }

    @JsonProperty
    @Nullable
    public String regexPathPrefix() {
        return this.regexPathPrefix;
    }

    @JsonProperty
    @Nullable
    public String fragment() {
        return this.fragment;
    }

    @JsonProperty
    @Nullable
    public MediaType defaultMimeType() {
        return this.defaultMimeType;
    }

    @JsonProperty
    public Set<MediaType> availableMimeTypes() {
        return this.availableMimeTypes;
    }

    public int hashCode() {
        return Objects.hash(this.hostnamePattern, this.pathMapping, this.regexPathPrefix, this.fragment, this.defaultMimeType, this.availableMimeTypes);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof EndpointInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EndpointInfo that = (EndpointInfo)obj;
        return this.hostnamePattern.equals(that.hostnamePattern) && this.pathMapping.equals(that.pathMapping) && Objects.equals(this.regexPathPrefix, that.regexPathPrefix) && Objects.equals(this.fragment, that.fragment) && Objects.equals(this.defaultMimeType, that.defaultMimeType) && this.availableMimeTypes.equals(that.availableMimeTypes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("hostnamePattern", this.hostnamePattern).add("pathMapping", this.pathMapping).add("regexPathPrefix", this.regexPathPrefix).add("fragment", this.fragment).add("defaultMimeType", this.defaultMimeType).add("availableMimeTypes", this.availableMimeTypes).toString();
    }
}

