/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth1aToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth1aTokenBuilder;
import io.opentelemetry.testing.internal.armeria.internal.common.PercentDecoder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth1aTokenExtractor
implements Function<RequestHeaders, OAuth1aToken> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth1aTokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)oauth\\s+(?<parameters>\\S+)\\s*");
    private final AsciiString header;

    OAuth1aTokenExtractor(CharSequence header) {
        this.header = HttpHeaderNames.of(header);
    }

    @Override
    @Nullable
    public OAuth1aToken apply(RequestHeaders headers) {
        String authorization = Objects.requireNonNull(headers, "headers").get(this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: " + authorization);
            return null;
        }
        OAuth1aTokenBuilder builder = AuthToken.builderForOAuth1a();
        for (String token : matcher.group("parameters").split(",")) {
            int sep = token.indexOf(61);
            if (sep == -1 || token.charAt(sep + 1) != '\"' || token.charAt(token.length() - 1) != '\"') {
                logger.warn("Invalid token: " + token);
                return null;
            }
            String key = token.substring(0, sep);
            String value = token.substring(sep + 2, token.length() - 1);
            builder.put(PercentDecoder.decodeComponent(key), PercentDecoder.decodeComponent(value));
        }
        return builder.build();
    }
}

