/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.armeria.server.ServerPort;
import io.opentelemetry.testing.internal.armeria.server.ServerPortMetric;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@UnstableApi
public final class ServerMetrics {
    static final String ALL_REQUESTS_METER_NAME = "armeria.server.all.requests";
    static final String ALL_CONNECTIONS_METER_NAME = "armeria.server.connections";
    private final Set<ServerPortMetric> serverPortMetrics = new CopyOnWriteArraySet<ServerPortMetric>();
    private final MeterRegistry meterRegistry;

    ServerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    void addServerPort(ServerPort serverPort) {
        ServerPortMetric serverPortMetric = serverPort.serverPortMetric();
        assert (serverPortMetric != null);
        if (this.serverPortMetrics.add(serverPortMetric)) {
            serverPortMetric.bindTo(this.meterRegistry, serverPort);
        }
    }

    public long pendingRequests() {
        return this.pendingHttp1Requests() + this.pendingHttp2Requests();
    }

    public long pendingHttp1Requests() {
        return this.serverPortMetrics.stream().mapToLong(ServerPortMetric::pendingHttp1Requests).sum();
    }

    public long pendingHttp2Requests() {
        return this.serverPortMetrics.stream().mapToLong(ServerPortMetric::pendingHttp2Requests).sum();
    }

    public long activeRequests() {
        return this.activeHttp1WebSocketRequests() + this.activeHttp1Requests() + this.activeHttp2Requests();
    }

    public long activeHttp1WebSocketRequests() {
        return this.serverPortMetrics.stream().mapToLong(ServerPortMetric::activeHttp1WebSocketRequests).sum();
    }

    public long activeHttp1Requests() {
        return this.serverPortMetrics.stream().mapToLong(ServerPortMetric::activeHttp1Requests).sum();
    }

    public long activeHttp2Requests() {
        return this.serverPortMetrics.stream().mapToLong(ServerPortMetric::activeHttp2Requests).sum();
    }

    public int activeConnections() {
        return Ints.saturatedCast(this.serverPortMetrics.stream().mapToLong(ServerPortMetric::activeConnections).sum());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serverPortMetrics", this.serverPortMetrics).toString();
    }
}

