/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.CharMatcher;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.net.HostAndPort;
import io.opentelemetry.testing.internal.armeria.server.ClientAddressSource;
import io.opentelemetry.testing.internal.armeria.server.ProxiedAddresses;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpHeaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpHeaderUtil.class);
    private static final Splitter CSV_SPLITTER = Splitter.on(',').omitEmptyStrings();
    private static final Splitter.MapSplitter TOKEN_SPLITTER = Splitter.on(';').omitEmptyStrings().withKeyValueSeparator('=');
    private static final CharMatcher QUOTED_STRING_TRIMMER = CharMatcher.is('\"');
    static final Function<String, @Nullable String> FORWARDED_CONVERTER = value -> TOKEN_SPLITTER.split((CharSequence)value).get("for");
    private static boolean warnedIllegalAbsoluteUriTransformer;

    static ProxiedAddresses determineProxiedAddresses(HttpHeaders headers, List<ClientAddressSource> clientAddressSources, @Nullable ProxiedAddresses proxiedAddresses, InetSocketAddress remoteAddress, Predicate<? super InetAddress> filter) {
        for (ClientAddressSource source : clientAddressSources) {
            ImmutableCollection addresses;
            if (source.isProxyProtocol()) {
                if (proxiedAddresses == null || !filter.test(proxiedAddresses.sourceAddress().getAddress()) || !filter.test(proxiedAddresses.destinationAddresses().get(0).getAddress())) continue;
                return proxiedAddresses;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            AsciiString name = source.header();
            if (name.equals(HttpHeaderNames.FORWARDED)) {
                headers.getAll(HttpHeaderNames.FORWARDED).forEach(forwarded -> HttpHeaderUtil.getAllValidAddress(forwarded, FORWARDED_CONVERTER, filter, builder));
            } else {
                headers.getAll(name).forEach(header -> HttpHeaderUtil.getAllValidAddress(header, Function.identity(), filter, builder));
            }
            if ((addresses = builder.build()).isEmpty()) continue;
            return ProxiedAddresses.of((InetSocketAddress)addresses.get(0), ((ImmutableList)addresses).subList(1, addresses.size()));
        }
        return ProxiedAddresses.of(remoteAddress);
    }

    static void getAllValidAddress(@Nullable String headerValue, Function<String, @Nullable String> valueConverter, Predicate<? super InetAddress> filter, ImmutableList.Builder<InetSocketAddress> accumulator) {
        if (Strings.isNullOrEmpty(headerValue)) {
            return;
        }
        for (String value : CSV_SPLITTER.split(headerValue)) {
            String v = valueConverter.apply(value);
            if (Strings.isNullOrEmpty(v)) continue;
            try {
                InetSocketAddress addr = HttpHeaderUtil.createInetSocketAddress(v);
                if (addr == null || !filter.test(addr.getAddress())) continue;
                accumulator.add((Object)addr);
            }
            catch (UnknownHostException e) {
                logger.debug("Failed to create an InetSocketAddress: {}", (Object)v, (Object)e);
            }
        }
    }

    @Nullable
    private static InetSocketAddress createInetSocketAddress(String address) throws UnknownHostException {
        char firstChar = address.charAt(0);
        if (firstChar == '_' || firstChar == 'u' && "unknown".equals(address)) {
            return null;
        }
        String addr = firstChar == '\"' ? QUOTED_STRING_TRIMMER.trimFrom(address) : address;
        try {
            HostAndPort hostAndPort = HostAndPort.fromString(addr);
            byte[] addressBytes = NetUtil.createByteArrayFromIpAddressString(hostAndPort.getHost());
            if (addressBytes == null) {
                logger.debug("Failed to parse an address: {}", (Object)address);
                return null;
            }
            return new InetSocketAddress(InetAddress.getByAddress(addressBytes), hostAndPort.getPortOrDefault(0));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to parse an address: {}", (Object)address, (Object)e);
            return null;
        }
    }

    static void ensureUniqueMediaTypes(Iterable<MediaType> types, String typeName) {
        Objects.requireNonNull(types, typeName);
        HashSet<MediaType> set = new HashSet<MediaType>();
        for (MediaType type : types) {
            if (set.add(type)) continue;
            throw new IllegalArgumentException("duplicated media type in " + typeName + ": " + type);
        }
    }

    static String maybeTransformAbsoluteUri(String path, Function<? super String, String> absoluteUriTransformer) throws URISyntaxException {
        String newPath;
        if (HttpHeaderUtil.isValidHttp2Path(path)) {
            return path;
        }
        if (!ArmeriaHttpUtil.isAbsoluteUri(path)) {
            throw HttpHeaderUtil.newInvalidPathException(path);
        }
        try {
            newPath = absoluteUriTransformer.apply(path);
        }
        catch (Exception e) {
            HttpHeaderUtil.warnExceptionThrowingAbsoluteUriTransformer(e);
            throw HttpHeaderUtil.newInvalidPathException(path);
        }
        if (newPath == null || newPath.isEmpty()) {
            HttpHeaderUtil.warnNullReturningAbsoluteUriTransformer();
            throw HttpHeaderUtil.newInvalidPathException(path);
        }
        if (!HttpHeaderUtil.isValidHttp2Path(newPath)) {
            throw HttpHeaderUtil.newInvalidPathException(path);
        }
        return newPath;
    }

    private static void warnExceptionThrowingAbsoluteUriTransformer(Exception e) {
        if (!warnedIllegalAbsoluteUriTransformer) {
            warnedIllegalAbsoluteUriTransformer = true;
            logger.warn("absoluteUriTransformer.apply() raised an exception; returning 400 Bad Request", (Throwable)e);
        }
    }

    private static void warnNullReturningAbsoluteUriTransformer() {
        if (!warnedIllegalAbsoluteUriTransformer) {
            warnedIllegalAbsoluteUriTransformer = true;
            logger.warn("absoluteUriTransformer.apply() returned null; returning 400 Bad Request");
        }
    }

    private static URISyntaxException newInvalidPathException(String path) {
        return new URISyntaxException(path, "neither origin form nor asterisk form");
    }

    private static boolean isValidHttp2Path(String path) {
        return path.charAt(0) == '/' || "*".equals(path);
    }

    private HttpHeaderUtil() {
    }
}

