/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.server.DecoratingHttpServiceFunction;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import java.util.Objects;

final class FunctionalDecoratingHttpService
extends SimpleDecoratingHttpService {
    private final DecoratingHttpServiceFunction function;

    FunctionalDecoratingHttpService(HttpService delegate, DecoratingHttpServiceFunction function) {
        super(delegate);
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return this.function.serve((HttpService)this.unwrap(), ctx, req);
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        this.function.serviceAdded(cfg);
    }

    @Override
    public String toString() {
        return FunctionalDecoratingHttpService.class.getSimpleName() + '(' + this.unwrap() + ", " + this.function + ')';
    }
}

