/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.internal.server.RouteDecoratingService;
import io.opentelemetry.testing.internal.armeria.internal.server.RouteUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.DecoratingHttpServiceFunction;
import io.opentelemetry.testing.internal.armeria.server.FunctionalDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpServiceWithRoutes;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.ServerBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigSetters;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfigsBuilder;
import io.opentelemetry.testing.internal.armeria.server.VirtualHostBuilder;
import io.opentelemetry.testing.internal.armeria.server.annotation.ExceptionHandlerFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.RequestConverterFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

abstract class AbstractContextPathServicesBuilder<SELF extends AbstractContextPathServicesBuilder<SELF, T>, T extends ServiceConfigsBuilder<T>>
implements ServiceConfigsBuilder<SELF> {
    private final Set<String> contextPaths;
    private final T parent;
    private final VirtualHostBuilder virtualHostBuilder;

    AbstractContextPathServicesBuilder(T parent, VirtualHostBuilder virtualHostBuilder, Set<String> contextPaths) {
        Preconditions.checkArgument(!contextPaths.isEmpty(), "At least one context path is required");
        for (String contextPath : contextPaths) {
            RouteUtil.ensureAbsolutePath(contextPath, "contextPath");
        }
        this.parent = parent;
        this.contextPaths = ImmutableSet.copyOf(contextPaths);
        this.virtualHostBuilder = virtualHostBuilder;
    }

    final SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF serviceUnder(String pathPrefix, HttpService service) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        HttpServiceWithRoutes serviceWithRoutes = service.as(HttpServiceWithRoutes.class);
        if (serviceWithRoutes != null) {
            serviceWithRoutes.routes().forEach(route -> {
                for (String contextPath : this.contextPaths) {
                    ServiceConfigBuilder serviceConfigBuilder = new ServiceConfigBuilder(route.withPrefix(pathPrefix), contextPath, service);
                    serviceConfigBuilder.addMappedRoute((Route)route);
                    this.addServiceConfigSetters(serviceConfigBuilder);
                }
            });
        } else {
            this.service(Route.builder().pathPrefix(pathPrefix).build(), service);
        }
        return this.self();
    }

    @Override
    public SELF service(String pathPattern, HttpService service) {
        return (SELF)this.service(Route.builder().path(pathPattern).build(), service);
    }

    @Override
    public SELF service(Route route, HttpService service) {
        for (String contextPath : this.contextPaths) {
            this.addServiceConfigSetters(new ServiceConfigBuilder(route, contextPath, service));
        }
        return this.self();
    }

    @Override
    public SELF service(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(serviceWithRoutes, "serviceWithRoutes");
        Objects.requireNonNull(serviceWithRoutes.routes(), "serviceWithRoutes.routes()");
        Objects.requireNonNull(decorators, "decorators");
        HttpService decorated = ServerBuilder.decorate(serviceWithRoutes, decorators);
        serviceWithRoutes.routes().forEach(route -> this.service((Route)route, decorated));
        return this.self();
    }

    @Override
    public SELF service(HttpServiceWithRoutes serviceWithRoutes, Function<? super HttpService, ? extends HttpService> ... decorators) {
        return (SELF)this.service(serviceWithRoutes, ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    @Override
    public SELF annotatedService(Object service) {
        return (SELF)this.annotatedService("/", service, Function.identity(), (Iterable)ImmutableList.of());
    }

    @Override
    public SELF annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return (SELF)this.annotatedService("/", service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public SELF annotatedService(Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return (SELF)this.annotatedService("/", service, (Function)decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public SELF annotatedService(String pathPrefix, Object service) {
        return (SELF)this.annotatedService(pathPrefix, service, Function.identity(), (Iterable)ImmutableList.of());
    }

    @Override
    public SELF annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return (SELF)this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public SELF annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return (SELF)this.annotatedService(pathPrefix, service, (Function)decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public SELF annotatedService(String pathPrefix, Object service, Iterable<?> exceptionHandlersAndConverters) {
        return (SELF)this.annotatedService(pathPrefix, service, Function.identity(), (Iterable)Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    @Override
    public SELF annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<?> exceptionHandlersAndConverters) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters");
        AnnotatedServiceExtensions configurator = AnnotatedServiceExtensions.ofExceptionHandlersAndConverters(exceptionHandlersAndConverters);
        return (SELF)this.annotatedService(pathPrefix, service, (Function)decorator, configurator.exceptionHandlers(), configurator.requestConverters(), configurator.responseConverters());
    }

    @Override
    public abstract SELF annotatedService(String var1, Object var2, Function<? super HttpService, ? extends HttpService> var3, Iterable<? extends ExceptionHandlerFunction> var4, Iterable<? extends RequestConverterFunction> var5, Iterable<? extends ResponseConverterFunction> var6);

    @Override
    public SELF decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        return (SELF)this.decorator(Route.ofCatchAll(), (Function)decorator);
    }

    @Override
    public SELF decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (SELF)this.decorator(Route.ofCatchAll(), decoratingHttpServiceFunction);
    }

    @Override
    public SELF decorator(String pathPattern, Function<? super HttpService, ? extends HttpService> decorator) {
        return (SELF)this.decorator(Route.builder().path(pathPattern).build(), (Function)decorator);
    }

    @Override
    public SELF decorator(String pathPattern, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (SELF)this.decorator(Route.builder().path(pathPattern).build(), decoratingHttpServiceFunction);
    }

    @Override
    public SELF decorator(Route route, Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(decorator, "decorator");
        for (String contextPath : this.contextPaths) {
            this.addRouteDecoratingService(new RouteDecoratingService(route, contextPath, decorator));
        }
        return this.self();
    }

    @Override
    public SELF decorator(Route route, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        Objects.requireNonNull(decoratingHttpServiceFunction, "decoratingHttpServiceFunction");
        return (SELF)this.decorator(route, delegate -> new FunctionalDecoratingHttpService((HttpService)delegate, decoratingHttpServiceFunction));
    }

    @Override
    public SELF decoratorUnder(String prefix, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (SELF)this.decorator(Route.builder().pathPrefix(prefix).build(), decoratingHttpServiceFunction);
    }

    @Override
    public SELF decoratorUnder(String prefix, Function<? super HttpService, ? extends HttpService> decorator) {
        return (SELF)this.decorator(Route.builder().pathPrefix(prefix).build(), (Function)decorator);
    }

    SELF addServiceConfigSetters(ServiceConfigSetters<?> serviceConfigSetters) {
        this.virtualHostBuilder.addServiceConfigSetters(serviceConfigSetters);
        return this.self();
    }

    SELF addRouteDecoratingService(RouteDecoratingService routeDecoratingService) {
        this.virtualHostBuilder.addRouteDecoratingService(routeDecoratingService);
        return this.self();
    }

    public T and() {
        return this.parent;
    }

    final Set<String> contextPaths() {
        return this.contextPaths;
    }
}

