/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.scanners;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Predicate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Predicates;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Multimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.Configuration;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.ReflectionsException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.adapters.MetadataAdapter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.scanners.Scanner;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs.Vfs;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Multimap<String, String> store;
    private Predicate<String> resultFilter = Predicates.alwaysTrue();

    @Override
    public boolean acceptsInput(String file) {
        return this.getMetadataAdapter().acceptsInput(file);
    }

    @Override
    public Object scan(Vfs.File file, Object classObject) {
        if (classObject == null) {
            try {
                classObject = this.configuration.getMetadataAdapter().getOfCreateClassObject(file);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        this.scan(classObject);
        return classObject;
    }

    public abstract void scan(Object var1);

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Multimap<String, String> getStore() {
        return this.store;
    }

    @Override
    public void setStore(Multimap<String, String> store) {
        this.store = store;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter);
        return this;
    }

    @Override
    public boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.apply(fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

