/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.queues.unpadded;

import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.queues.LinkedArrayQueueUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.queues.unpadded.MpscChunkedUnpaddedArrayQueue;
import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.util.Pow2;
import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.util.RangeUtil;

public class MpscGrowableUnpaddedArrayQueue<E>
extends MpscChunkedUnpaddedArrayQueue<E> {
    public MpscGrowableUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedArrayQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (LinkedArrayQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

