/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.util.concurrent;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.util.concurrent.AbstractFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class Platform {
    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static void interruptCurrentThread() {
        Thread.currentThread().interrupt();
    }

    static void rethrowIfErrorOtherThanStackOverflow(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof Error && !(t instanceof StackOverflowError)) {
            throw (Error)t;
        }
    }

    static <V> V get(AbstractFuture<V> future) throws InterruptedException, ExecutionException {
        return future.blockingGet();
    }

    static <V> V get(AbstractFuture<V> future, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.blockingGet(timeout, unit);
    }
}

