/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect;

import com.google.j2objc.annotations.Weak;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.BaseImmutableMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.CollectPreconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.CollectSpliterators;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterators;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Maps;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Multimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Ordering;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Platform;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.SetMultimap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.UnmodifiableIterator;
import io.opentelemetry.testing.internal.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.testing.internal.errorprone.annotations.DoNotCall;
import io.opentelemetry.testing.internal.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import org.jspecify.annotations.Nullable;

public abstract class ImmutableMultimap<K, V>
extends BaseImmutableMultimap<K, V>
implements Serializable {
    final transient ImmutableMap<K, ? extends ImmutableCollection<V>> map;
    final transient int size;

    public static <K, V> ImmutableMultimap<K, V> of() {
        return ImmutableListMultimap.of();
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1) {
        return ImmutableListMultimap.of(k1, v1);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableMultimap(ImmutableMap<K, ? extends ImmutableCollection<V>> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract ImmutableCollection<V> get(K var1);

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final boolean remove(@Nullable Object key, @Nullable Object value) {
        throw new UnsupportedOperationException();
    }

    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return value != null && super.containsValue(value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.map.keySet();
    }

    @Override
    Set<K> createKeySet() {
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        return (ImmutableCollection)super.entries();
    }

    @Override
    ImmutableCollection<Map.Entry<K, V>> createEntries() {
        return new EntryCollection(this);
    }

    @Override
    UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
        return new UnmodifiableIterator<Map.Entry<K, V>>(){
            final Iterator<? extends Map.Entry<K, ? extends ImmutableCollection<V>>> asMapItr;
            @Nullable K currentKey;
            Iterator<V> valueItr;
            {
                this.asMapItr = ((ImmutableSet)ImmutableMultimap.this.map.entrySet()).iterator();
                this.currentKey = null;
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.valueItr.hasNext() || this.asMapItr.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.valueItr.hasNext()) {
                    Map.Entry entry = this.asMapItr.next();
                    this.currentKey = entry.getKey();
                    this.valueItr = entry.getValue().iterator();
                }
                return Maps.immutableEntry(Objects.requireNonNull(this.currentKey), this.valueItr.next());
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(((ImmutableCollection)((Object)((ImmutableMap)this.asMap()).entrySet())).spliterator(), keyToValueCollectionEntry -> {
            Object key = keyToValueCollectionEntry.getKey();
            Collection valueCollection = (Collection)keyToValueCollectionEntry.getValue();
            return CollectSpliterators.map(valueCollection.spliterator(), value -> Maps.immutableEntry(key, value));
        }, 0x40 | (this instanceof SetMultimap ? 1 : 0), this.size());
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @Override
    UnmodifiableIterator<V> valueIterator() {
        return new UnmodifiableIterator<V>(){
            Iterator<? extends ImmutableCollection<V>> valueCollectionItr;
            Iterator<V> valueItr;
            {
                this.valueCollectionItr = ((ImmutableCollection)ImmutableMultimap.this.map.values()).iterator();
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.valueItr.hasNext() || this.valueCollectionItr.hasNext();
            }

            @Override
            public V next() {
                if (!this.valueItr.hasNext()) {
                    this.valueItr = this.valueCollectionItr.next().iterator();
                }
                return this.valueItr.next();
            }
        };
    }

    @DoNotMock
    public static class Builder<K, V> {
        @Nullable Map<K, ImmutableCollection.Builder<V>> builderMap;
        @Nullable Comparator<? super K> keyComparator;
        @Nullable Comparator<? super V> valueComparator;
        int expectedValuesPerKey = 4;

        Map<K, ImmutableCollection.Builder<V>> ensureBuilderMapNonNull() {
            Map<K, ImmutableCollection.Builder<V>> result = this.builderMap;
            if (result == null) {
                this.builderMap = result = Platform.preservesInsertionOrderOnPutsMap();
            }
            return result;
        }

        ImmutableCollection.Builder<V> newValueCollectionBuilderWithExpectedSize(int expectedSize) {
            return ImmutableList.builderWithExpectedSize(expectedSize);
        }

        int expectedValueCollectionSize(int defaultExpectedValues, Iterable<?> values) {
            if (values instanceof Collection) {
                Collection collection = (Collection)values;
                return Math.max(defaultExpectedValues, collection.size());
            }
            return defaultExpectedValues;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            CollectPreconditions.checkEntryNotNull(key, value);
            ImmutableCollection.Builder<V> valuesBuilder = this.ensureBuilderMapNonNull().get(key);
            if (valuesBuilder == null) {
                valuesBuilder = this.newValueCollectionBuilderWithExpectedSize(this.expectedValuesPerKey);
                this.ensureBuilderMapNonNull().put(key, valuesBuilder);
            }
            valuesBuilder.add(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            if (key == null) {
                throw new NullPointerException("null key in entry: null=" + Iterables.toString(values));
            }
            Iterator<V> valuesItr = values.iterator();
            if (!valuesItr.hasNext()) {
                return this;
            }
            ImmutableCollection.Builder<V> valuesBuilder = this.ensureBuilderMapNonNull().get(key);
            if (valuesBuilder == null) {
                valuesBuilder = this.newValueCollectionBuilderWithExpectedSize(this.expectedValueCollectionSize(this.expectedValuesPerKey, values));
                this.ensureBuilderMapNonNull().put(key, valuesBuilder);
            }
            while (valuesItr.hasNext()) {
                V value = valuesItr.next();
                CollectPreconditions.checkEntryNotNull(key, value);
                valuesBuilder.add(value);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, V ... values) {
            return this.putAll(key, (Iterable<? extends V>)Arrays.asList(values));
        }

        public ImmutableMultimap<K, V> build() {
            if (this.builderMap == null) {
                return ImmutableListMultimap.of();
            }
            Collection<Map.Entry<K, ImmutableCollection.Builder<V>>> mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableListMultimap.fromMapBuilderEntries(mapEntries, this.valueComparator);
        }
    }

    private static class EntryCollection<K, V>
    extends ImmutableCollection<Map.Entry<K, V>> {
        @Weak
        final ImmutableMultimap<K, V> multimap;

        EntryCollection(ImmutableMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        boolean isPartialView() {
            return this.multimap.isPartialView();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    private static final class Values<K, V>
    extends ImmutableCollection<V> {
        @Weak
        private final transient ImmutableMultimap<K, V> multimap;

        Values(ImmutableMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.multimap.containsValue(object);
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return this.multimap.valueIterator();
        }

        @Override
        int copyIntoArray(@Nullable Object[] dst, int offset) {
            for (ImmutableCollection valueCollection : this.multimap.map.values()) {
                offset = valueCollection.copyIntoArray(dst, offset);
            }
            return offset;
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }
}

