/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.futures;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CompletableFutures {
    public static <T> CompletableFuture<List<T>> allAsList(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture[] all = new CompletableFuture[stages.size()];
        for (int i = 0; i < stages.size(); ++i) {
            all[i] = stages.get(i).toCompletableFuture();
        }
        CompletableFuture<Void> allOf = CompletableFuture.allOf(all);
        for (int i = 0; i < all.length; ++i) {
            all[i].exceptionally(throwable -> {
                if (!allOf.isDone()) {
                    allOf.completeExceptionally((Throwable)throwable);
                }
                return null;
            });
        }
        return allOf.thenApply(ignored -> {
            ArrayList result = new ArrayList(all.length);
            for (int i = 0; i < all.length; ++i) {
                result.add(all[i].join());
            }
            return result;
        });
    }

    public static <T> CompletableFuture<List<T>> successfulAsList(List<? extends CompletionStage<T>> stages, Function<Throwable, ? extends T> defaultValueMapper) {
        return stages.stream().map(f -> f.exceptionally(defaultValueMapper)).collect(CompletableFutures.joinList());
    }

    public static <T, S extends CompletionStage<? extends T>> Collector<S, ?, CompletableFuture<List<T>>> joinList() {
        return Collectors.collectingAndThen(Collectors.toList(), CompletableFutures::allAsList);
    }
}

