/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.sphincs;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCSphincs256PrivateKey
implements SPHINCSKey,
PrivateKey {
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSphincs256PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.treeDigest = SPHINCS256KeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PrivateKey) {
            BCSphincs256PrivateKey bCSphincs256PrivateKey = (BCSphincs256PrivateKey)object;
            return this.treeDigest.equals(bCSphincs256PrivateKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), bCSphincs256PrivateKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo;
            if (this.params.getTreeDigest() != null) {
                privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(this.params.getKeyData()), this.attributes);
            }
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

