/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.snova;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.bc.BCObjectIdentifiers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.snova.BCSnovaPrivateKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.snova.BCSnovaPublicKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.util.BaseKeyFactorySpi;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;

public class SnovaKeyFactorySpi
extends BaseKeyFactorySpi {
    private static final Set<ASN1ObjectIdentifier> keyOids = new HashSet<ASN1ObjectIdentifier>();

    public SnovaKeyFactorySpi() {
        super(keyOids);
    }

    public final KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof BCSnovaPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
        } else if (key instanceof BCSnovaPublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
    }

    @Override
    public final Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof BCSnovaPrivateKey || key instanceof BCSnovaPublicKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type");
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        return new BCSnovaPrivateKey(privateKeyInfo);
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return new BCSnovaPublicKey(subjectPublicKeyInfo);
    }

    static {
        keyOids.add(BCObjectIdentifiers.snova_24_5_4_ssk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_4_esk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_4_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_4_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_5_ssk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_5_esk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_5_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_24_5_5_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_25_8_3_ssk);
        keyOids.add(BCObjectIdentifiers.snova_25_8_3_esk);
        keyOids.add(BCObjectIdentifiers.snova_25_8_3_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_25_8_3_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_29_6_5_ssk);
        keyOids.add(BCObjectIdentifiers.snova_29_6_5_esk);
        keyOids.add(BCObjectIdentifiers.snova_29_6_5_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_29_6_5_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_37_8_4_ssk);
        keyOids.add(BCObjectIdentifiers.snova_37_8_4_esk);
        keyOids.add(BCObjectIdentifiers.snova_37_8_4_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_37_8_4_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_37_17_2_ssk);
        keyOids.add(BCObjectIdentifiers.snova_37_17_2_esk);
        keyOids.add(BCObjectIdentifiers.snova_37_17_2_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_37_17_2_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_49_11_3_ssk);
        keyOids.add(BCObjectIdentifiers.snova_49_11_3_esk);
        keyOids.add(BCObjectIdentifiers.snova_49_11_3_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_49_11_3_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_56_25_2_ssk);
        keyOids.add(BCObjectIdentifiers.snova_56_25_2_esk);
        keyOids.add(BCObjectIdentifiers.snova_56_25_2_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_56_25_2_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_60_10_4_ssk);
        keyOids.add(BCObjectIdentifiers.snova_60_10_4_esk);
        keyOids.add(BCObjectIdentifiers.snova_60_10_4_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_60_10_4_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_66_15_3_ssk);
        keyOids.add(BCObjectIdentifiers.snova_66_15_3_esk);
        keyOids.add(BCObjectIdentifiers.snova_66_15_3_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_66_15_3_shake_esk);
        keyOids.add(BCObjectIdentifiers.snova_75_33_2_ssk);
        keyOids.add(BCObjectIdentifiers.snova_75_33_2_esk);
        keyOids.add(BCObjectIdentifiers.snova_75_33_2_shake_ssk);
        keyOids.add(BCObjectIdentifiers.snova_75_33_2_shake_esk);
    }
}

