/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.saber;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.StreamCipher;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.Xof;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA256Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA3Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA512Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHAKEDigest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.engines.AESEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.modes.SICBlockCipher;

abstract class Symmetric {
    Symmetric() {
    }

    static class AesSymmetric
    extends Symmetric {
        private final SHA256Digest sha256Digest = new SHA256Digest();
        private final SHA512Digest sha512Digest = new SHA512Digest();
        private final StreamCipher cipher = SICBlockCipher.newInstance(AESEngine.newInstance());

        AesSymmetric() {
        }
    }

    static class ShakeSymmetric
    extends Symmetric {
        private final SHA3Digest sha3Digest256;
        private final SHA3Digest sha3Digest512;
        private final Xof shakeDigest = new SHAKEDigest(128);

        ShakeSymmetric() {
            this.sha3Digest256 = new SHA3Digest(256);
            this.sha3Digest512 = new SHA3Digest(512);
        }
    }
}

