/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.saber;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.saber.Poly;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.saber.Symmetric;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.saber.Utils;

class SABEREngine {
    private final int SABER_L;
    private final int SABER_MU;
    private final int SABER_ET;
    private final int SABER_POLYCOINBYTES;
    private final int SABER_EQ;
    private final int SABER_POLYBYTES;
    private final int SABER_POLYVECBYTES;
    private final int SABER_POLYCOMPRESSEDBYTES;
    private final int SABER_POLYVECCOMPRESSEDBYTES;
    private final int SABER_SCALEBYTES_KEM;
    private final int SABER_INDCPA_PUBLICKEYBYTES;
    private final int SABER_INDCPA_SECRETKEYBYTES;
    private final int SABER_PUBLICKEYBYTES;
    private final int SABER_SECRETKEYBYTES;
    private final int SABER_BYTES_CCA_DEC;
    private final int defaultKeySize;
    private final int h1;
    private final int h2;
    private final Utils utils;
    private final Poly poly;
    private final boolean usingAES;
    protected final boolean usingEffectiveMasking;
    protected final Symmetric symmetric;

    public int getSABER_N() {
        return 256;
    }

    public int getSABER_EP() {
        return 10;
    }

    public int getSABER_KEYBYTES() {
        return 32;
    }

    public int getSABER_L() {
        return this.SABER_L;
    }

    public int getSABER_ET() {
        return this.SABER_ET;
    }

    public int getSABER_POLYBYTES() {
        return this.SABER_POLYBYTES;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public SABEREngine(int n, int n2, boolean bl, boolean bl2) {
        this.defaultKeySize = n2;
        this.usingAES = bl;
        this.usingEffectiveMasking = bl2;
        this.SABER_L = n;
        if (n == 2) {
            this.SABER_MU = 10;
            this.SABER_ET = 3;
        } else if (n == 3) {
            this.SABER_MU = 8;
            this.SABER_ET = 4;
        } else {
            this.SABER_MU = 6;
            this.SABER_ET = 6;
        }
        this.symmetric = bl ? new Symmetric.AesSymmetric() : new Symmetric.ShakeSymmetric();
        if (bl2) {
            this.SABER_EQ = 12;
            this.SABER_POLYCOINBYTES = 64;
        } else {
            this.SABER_EQ = 13;
            this.SABER_POLYCOINBYTES = this.SABER_MU * 256 / 8;
        }
        this.SABER_POLYBYTES = this.SABER_EQ * 256 / 8;
        this.SABER_POLYVECBYTES = this.SABER_L * this.SABER_POLYBYTES;
        this.SABER_POLYCOMPRESSEDBYTES = 320;
        this.SABER_POLYVECCOMPRESSEDBYTES = this.SABER_L * this.SABER_POLYCOMPRESSEDBYTES;
        this.SABER_SCALEBYTES_KEM = this.SABER_ET * 256 / 8;
        this.SABER_INDCPA_PUBLICKEYBYTES = this.SABER_POLYVECCOMPRESSEDBYTES + 32;
        this.SABER_INDCPA_SECRETKEYBYTES = this.SABER_POLYVECBYTES;
        this.SABER_PUBLICKEYBYTES = this.SABER_INDCPA_PUBLICKEYBYTES;
        this.SABER_SECRETKEYBYTES = this.SABER_INDCPA_SECRETKEYBYTES + this.SABER_INDCPA_PUBLICKEYBYTES + 32 + 32;
        this.SABER_BYTES_CCA_DEC = this.SABER_POLYVECCOMPRESSEDBYTES + this.SABER_SCALEBYTES_KEM;
        this.h1 = 1 << this.SABER_EQ - 10 - 1;
        this.h2 = 256 - (1 << 10 - this.SABER_ET - 1) + (1 << this.SABER_EQ - 10 - 1);
        this.utils = new Utils(this);
        this.poly = new Poly(this);
    }
}

