/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.PolyVecL;

class PolyVecMatrix {
    private final PolyVecL[] matrix;

    PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumK();
        this.matrix = new PolyVecL[n];
        for (int i = 0; i < n; ++i) {
            this.matrix[i] = new PolyVecL(mLDSAEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int i = 0; i < this.matrix.length; ++i) {
            polyVecK.getVectorIndex(i).pointwiseAccountMontgomery(this.matrix[i], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].uniformBlocks(byArray, i << 8);
        }
    }
}

