/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.PolyVecL;

class Packing {
    static byte[] packPublicKey(PolyVecK polyVecK, MLDSAEngine mLDSAEngine) {
        byte[] byArray = new byte[mLDSAEngine.getCryptoPublicKeyBytes() - 32];
        for (int i = 0; i < mLDSAEngine.getDilithiumK(); ++i) {
            System.arraycopy(polyVecK.getVectorIndex(i).polyt1Pack(), 0, byArray, i * 320, 320);
        }
        return byArray;
    }

    static byte[][] packSecretKey(byte[] byArray, byte[] byArray2, byte[] byArray3, PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, MLDSAEngine mLDSAEngine) {
        int n;
        byte[][] byArrayArray = new byte[6][];
        byArrayArray[0] = byArray;
        byArrayArray[1] = byArray3;
        byArrayArray[2] = byArray2;
        byArrayArray[3] = new byte[mLDSAEngine.getDilithiumL() * mLDSAEngine.getDilithiumPolyEtaPackedBytes()];
        for (n = 0; n < mLDSAEngine.getDilithiumL(); ++n) {
            polyVecL.getVectorIndex(n).polyEtaPack(byArrayArray[3], n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
        }
        byArrayArray[4] = new byte[mLDSAEngine.getDilithiumK() * mLDSAEngine.getDilithiumPolyEtaPackedBytes()];
        for (n = 0; n < mLDSAEngine.getDilithiumK(); ++n) {
            polyVecK2.getVectorIndex(n).polyEtaPack(byArrayArray[4], n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
        }
        byArrayArray[5] = new byte[mLDSAEngine.getDilithiumK() * 416];
        for (n = 0; n < mLDSAEngine.getDilithiumK(); ++n) {
            polyVecK.getVectorIndex(n).polyt0Pack(byArrayArray[5], n * 416);
        }
        return byArrayArray;
    }

    static void unpackSecretKey(PolyVecK polyVecK, PolyVecL polyVecL, PolyVecK polyVecK2, byte[] byArray, byte[] byArray2, byte[] byArray3, MLDSAEngine mLDSAEngine) {
        int n;
        for (n = 0; n < mLDSAEngine.getDilithiumL(); ++n) {
            polyVecL.getVectorIndex(n).polyEtaUnpack(byArray2, n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
        }
        for (n = 0; n < mLDSAEngine.getDilithiumK(); ++n) {
            polyVecK2.getVectorIndex(n).polyEtaUnpack(byArray3, n * mLDSAEngine.getDilithiumPolyEtaPackedBytes());
        }
        for (n = 0; n < mLDSAEngine.getDilithiumK(); ++n) {
            polyVecK.getVectorIndex(n).polyt0Unpack(byArray, n * 416);
        }
    }
}

