/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.Composer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.DigestUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.SeedDerive;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Pack;

class LM_OTS {
    public static int coef(byte[] byArray, int n, int n2) {
        int n3 = n * n2 / 8;
        int n4 = 8 / n2;
        int n5 = n2 * (~n & n4 - 1);
        int n6 = (1 << n2) - 1;
        return byArray[n3] >>> n5 & n6;
    }

    public static int cksm(byte[] byArray, int n, LMOtsParameters lMOtsParameters) {
        int n2 = 0;
        int n3 = lMOtsParameters.getW();
        int n4 = (1 << n3) - 1;
        for (int i = 0; i < n * 8 / lMOtsParameters.getW(); ++i) {
            n2 = n2 + n4 - LM_OTS.coef(byArray, i, lMOtsParameters.getW());
        }
        return n2 << lMOtsParameters.getLs();
    }

    static byte[] lms_ots_generatePublicKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        Digest digest = DigestUtil.getDigest(lMOtsParameters);
        byte[] byArray3 = Composer.compose().bytes(byArray).u32str(n).u16str(-32640).padUntil(0, 22).build();
        digest.update(byArray3, 0, byArray3.length);
        Digest digest2 = DigestUtil.getDigest(lMOtsParameters);
        byte[] byArray4 = Composer.compose().bytes(byArray).u32str(n).padUntil(0, 23 + digest2.getDigestSize()).build();
        SeedDerive seedDerive = new SeedDerive(byArray, byArray2, DigestUtil.getDigest(lMOtsParameters));
        seedDerive.setQ(n);
        seedDerive.setJ(0);
        int n2 = lMOtsParameters.getP();
        int n3 = lMOtsParameters.getN();
        int n4 = (1 << lMOtsParameters.getW()) - 1;
        for (int i = 0; i < n2; ++i) {
            seedDerive.deriveSeed(byArray4, i < n2 - 1, 23);
            Pack.shortToBigEndian((short)i, byArray4, 20);
            for (int j = 0; j < n4; ++j) {
                byArray4[22] = (byte)j;
                digest2.update(byArray4, 0, byArray4.length);
                digest2.doFinal(byArray4, 23);
            }
            digest.update(byArray4, 23, n3);
        }
        byte[] byArray5 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray5, 0);
        return byArray5;
    }

    public static LMOtsSignature lm_ots_generate_signature(LMOtsPrivateKey lMOtsPrivateKey, byte[] byArray, byte[] byArray2) {
        LMOtsParameters lMOtsParameters = lMOtsPrivateKey.getParameter();
        int n = lMOtsParameters.getN();
        int n2 = lMOtsParameters.getP();
        int n3 = lMOtsParameters.getW();
        byte[] byArray3 = new byte[n2 * n];
        Digest digest = DigestUtil.getDigest(lMOtsParameters);
        SeedDerive seedDerive = lMOtsPrivateKey.getDerivationFunction();
        int n4 = LM_OTS.cksm(byArray, n, lMOtsParameters);
        byArray[n] = (byte)(n4 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)n4;
        byte[] byArray4 = Composer.compose().bytes(lMOtsPrivateKey.getI()).u32str(lMOtsPrivateKey.getQ()).padUntil(0, 23 + n).build();
        seedDerive.setJ(0);
        for (int i = 0; i < n2; ++i) {
            Pack.shortToBigEndian((short)i, byArray4, 20);
            seedDerive.deriveSeed(byArray4, i < n2 - 1, 23);
            int n5 = LM_OTS.coef(byArray, i, n3);
            for (int j = 0; j < n5; ++j) {
                byArray4[22] = (byte)j;
                digest.update(byArray4, 0, 23 + n);
                digest.doFinal(byArray4, 23);
            }
            System.arraycopy(byArray4, 23, byArray3, n * i, n);
        }
        return new LMOtsSignature(lMOtsParameters, byArray2, byArray3);
    }
}

